package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait InferenceDataImportStrategy {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy
}
object InferenceDataImportStrategy {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy
  ): zio.aws.lookoutequipment.model.InferenceDataImportStrategy = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.NO_IMPORT =>
      val r = NO_IMPORT
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.ADD_WHEN_EMPTY =>
      val r = ADD_WHEN_EMPTY
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.OVERWRITE =>
      val r = OVERWRITE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.InferenceDataImportStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_IMPORT
      extends zio.aws.lookoutequipment.model.InferenceDataImportStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.NO_IMPORT
  }
  case object ADD_WHEN_EMPTY
      extends zio.aws.lookoutequipment.model.InferenceDataImportStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.ADD_WHEN_EMPTY
  }
  case object OVERWRITE
      extends zio.aws.lookoutequipment.model.InferenceDataImportStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy.OVERWRITE
  }
}
