package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersion,
  ModelVersionArn,
  ModelArn,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportModelVersionResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    modelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    modelVersion: Optional[ModelVersion] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse = {
    import ImportModelVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.modelVersionArn)
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.Long)
      )(_.modelVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ImportModelVersionResponse
      .wrap(buildAwsValue())
}
object ImportModelVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ImportModelVersionResponse =
      zio.aws.lookoutequipment.model.ImportModelVersionResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        modelVersionArn.map(value => value),
        modelVersion.map(value => value),
        status.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def modelVersionArn: Optional[ModelVersionArn]
    def modelVersion: Optional[ModelVersion]
    def status: Optional[zio.aws.lookoutequipment.model.ModelVersionStatus]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField("modelVersionArn", modelVersionArn)
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse
  ) extends zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val modelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
      )
    override val status
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse
  ): zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly =
    new Wrapper(impl)
}
