package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersionArn,
  IamRoleArn,
  NameOrArn,
  IdempotenceToken,
  ModelName,
  DatasetIdentifier
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportModelVersionRequest(
    sourceModelVersionArn: ModelVersionArn,
    modelName: Optional[ModelName] = Optional.Absent,
    datasetName: DatasetIdentifier,
    labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = Optional.Absent,
    clientToken: IdempotenceToken,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    serverSideKmsKeyId: Optional[NameOrArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lookoutequipment.model.Tag]] =
      Optional.Absent,
    inferenceDataImportStrategy: Optional[
      zio.aws.lookoutequipment.model.InferenceDataImportStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest = {
    import ImportModelVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest
      .builder()
      .sourceModelVersionArn(
        ModelVersionArn.unwrap(sourceModelVersionArn): java.lang.String
      )
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .datasetName(DatasetIdentifier.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          NameOrArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(inferenceDataImportStrategy.map(value => value.unwrap))(
        _.inferenceDataImportStrategy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ImportModelVersionRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ImportModelVersionRequest
      .wrap(buildAwsValue())
}
object ImportModelVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ImportModelVersionRequest =
      zio.aws.lookoutequipment.model.ImportModelVersionRequest(
        sourceModelVersionArn,
        modelName.map(value => value),
        datasetName,
        labelsInputConfiguration.map(value => value.asEditable),
        clientToken,
        roleArn.map(value => value),
        serverSideKmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferenceDataImportStrategy.map(value => value)
      )
    def sourceModelVersionArn: ModelVersionArn
    def modelName: Optional[ModelName]
    def datasetName: DatasetIdentifier
    def labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def clientToken: IdempotenceToken
    def roleArn: Optional[IamRoleArn]
    def serverSideKmsKeyId: Optional[NameOrArn]
    def tags: Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def inferenceDataImportStrategy
        : Optional[zio.aws.lookoutequipment.model.InferenceDataImportStrategy]
    def getSourceModelVersionArn: ZIO[Any, Nothing, ModelVersionArn] =
      ZIO.succeed(sourceModelVersionArn)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getDatasetName: ZIO[Any, Nothing, DatasetIdentifier] =
      ZIO.succeed(datasetName)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getInferenceDataImportStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceDataImportStrategy
    ] = AwsError.unwrapOptionField(
      "inferenceDataImportStrategy",
      inferenceDataImportStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest
  ) extends zio.aws.lookoutequipment.model.ImportModelVersionRequest.ReadOnly {
    override val sourceModelVersionArn: ModelVersionArn =
      zio.aws.lookoutequipment.model.primitives
        .ModelVersionArn(impl.sourceModelVersionArn())
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val datasetName: DatasetIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .DatasetIdentifier(impl.datasetName())
    override val labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val serverSideKmsKeyId: Optional[NameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
    override val tags
        : Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.Tag.wrap(item)
          }.toList
        )
    override val inferenceDataImportStrategy
        : Optional[zio.aws.lookoutequipment.model.InferenceDataImportStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceDataImportStrategy())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceDataImportStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest
  ): zio.aws.lookoutequipment.model.ImportModelVersionRequest.ReadOnly =
    new Wrapper(impl)
}
