package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IngestionJobId,
  DatasetArn,
  DatasetName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportDatasetResponse(
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      Optional.Absent,
    jobId: Optional[IngestionJobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse = {
    import ImportDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobId.map(value => IngestionJobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ImportDatasetResponse.wrap(buildAwsValue())
}
object ImportDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ImportDatasetResponse =
      zio.aws.lookoutequipment.model.ImportDatasetResponse(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        jobId.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def status: Optional[zio.aws.lookoutequipment.model.DatasetStatus]
    def jobId: Optional[IngestionJobId]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse
  ) extends zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.DatasetStatus.wrap(value))
    override val jobId: Optional[IngestionJobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse
  ): zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly =
    new Wrapper(impl)
}
