package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  NameOrArn,
  IdempotenceToken,
  DatasetName,
  DatasetArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportDatasetRequest(
    sourceDatasetArn: DatasetArn,
    datasetName: Optional[DatasetName] = Optional.Absent,
    clientToken: IdempotenceToken,
    serverSideKmsKeyId: Optional[NameOrArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lookoutequipment.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest = {
    import ImportDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest
      .builder()
      .sourceDatasetArn(DatasetArn.unwrap(sourceDatasetArn): java.lang.String)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          NameOrArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ImportDatasetRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ImportDatasetRequest.wrap(buildAwsValue())
}
object ImportDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ImportDatasetRequest =
      zio.aws.lookoutequipment.model.ImportDatasetRequest(
        sourceDatasetArn,
        datasetName.map(value => value),
        clientToken,
        serverSideKmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDatasetArn: DatasetArn
    def datasetName: Optional[DatasetName]
    def clientToken: IdempotenceToken
    def serverSideKmsKeyId: Optional[NameOrArn]
    def tags: Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def getSourceDatasetArn: ZIO[Any, Nothing, DatasetArn] =
      ZIO.succeed(sourceDatasetArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest
  ) extends zio.aws.lookoutequipment.model.ImportDatasetRequest.ReadOnly {
    override val sourceDatasetArn: DatasetArn =
      zio.aws.lookoutequipment.model.primitives
        .DatasetArn(impl.sourceDatasetArn())
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val serverSideKmsKeyId: Optional[NameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
    override val tags
        : Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest
  ): zio.aws.lookoutequipment.model.ImportDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
