package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  LookbackWindow,
  ModelArn,
  Timestamp,
  ModelName,
  RetrainingFrequency
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeRetrainingSchedulerResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    retrainingStartDate: Optional[Timestamp] = Optional.Absent,
    retrainingFrequency: Optional[RetrainingFrequency] = Optional.Absent,
    lookbackWindow: Optional[LookbackWindow] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      Optional.Absent,
    promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse = {
    import DescribeRetrainingSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        retrainingStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.retrainingStartDate)
      .optionallyWith(
        retrainingFrequency.map(value =>
          RetrainingFrequency.unwrap(value): java.lang.String
        )
      )(_.retrainingFrequency)
      .optionallyWith(
        lookbackWindow.map(value =>
          LookbackWindow.unwrap(value): java.lang.String
        )
      )(_.lookbackWindow)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(promoteMode.map(value => value.unwrap))(_.promoteMode)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse
      .wrap(buildAwsValue())
}
object DescribeRetrainingSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse =
      zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        retrainingStartDate.map(value => value),
        retrainingFrequency.map(value => value),
        lookbackWindow.map(value => value),
        status.map(value => value),
        promoteMode.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def retrainingStartDate: Optional[Timestamp]
    def retrainingFrequency: Optional[RetrainingFrequency]
    def lookbackWindow: Optional[LookbackWindow]
    def status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus]
    def promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getRetrainingStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("retrainingStartDate", retrainingStartDate)
    def getRetrainingFrequency: ZIO[Any, AwsError, RetrainingFrequency] =
      AwsError.unwrapOptionField("retrainingFrequency", retrainingFrequency)
    def getLookbackWindow: ZIO[Any, AwsError, LookbackWindow] =
      AwsError.unwrapOptionField("lookbackWindow", lookbackWindow)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getPromoteMode
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelPromoteMode] =
      AwsError.unwrapOptionField("promoteMode", promoteMode)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val retrainingStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingStartDate())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val retrainingFrequency: Optional[RetrainingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingFrequency())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.RetrainingFrequency(value)
        )
    override val lookbackWindow: Optional[LookbackWindow] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookbackWindow())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LookbackWindow(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerStatus.wrap(value)
        )
    override val promoteMode
        : Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promoteMode())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelPromoteMode.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse
  ): zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
