package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  Policy,
  PolicyRevisionId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyResponse(
    policyRevisionId: Optional[PolicyRevisionId] = Optional.Absent,
    resourcePolicy: Optional[Policy] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse = {
    import DescribeResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse
      .builder()
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .optionallyWith(
        resourcePolicy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.resourcePolicy)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse =
      zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse(
        policyRevisionId.map(value => value),
        resourcePolicy.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def policyRevisionId: Optional[PolicyRevisionId]
    def resourcePolicy: Optional[Policy]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
    def getResourcePolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse
  ) extends zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly {
    override val policyRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.PolicyRevisionId(value)
        )
    override val resourcePolicy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcePolicy())
      .map(value => zio.aws.lookoutequipment.model.primitives.Policy(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse
  ): zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
