package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest = {
    import DescribeResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest =
      zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest
  ) extends zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.lookoutequipment.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest
  ): zio.aws.lookoutequipment.model.DescribeResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
