package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{ModelVersion, ModelName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeModelVersionRequest(
    modelName: ModelName,
    modelVersion: ModelVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest = {
    import DescribeModelVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeModelVersionRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeModelVersionRequest
      .wrap(buildAwsValue())
}
object DescribeModelVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeModelVersionRequest =
      zio.aws.lookoutequipment.model
        .DescribeModelVersionRequest(modelName, modelVersion)
    def modelName: ModelName
    def modelVersion: ModelVersion
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest
  ) extends zio.aws.lookoutequipment.model.DescribeModelVersionRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutequipment.model.primitives
        .ModelVersion(impl.modelVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest
  ): zio.aws.lookoutequipment.model.DescribeModelVersionRequest.ReadOnly =
    new Wrapper(impl)
}
