package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  ModelVersionArn,
  IamRoleArn,
  BoundedLengthString,
  DatasetArn,
  OffCondition,
  ModelArn,
  Timestamp,
  ModelMetrics,
  DatasetName,
  ModelVersion,
  Integer,
  ModelName,
  KmsKeyArn,
  InlineDataSchema
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeModelResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    schema: Optional[InlineDataSchema] = Optional.Absent,
    labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = Optional.Absent,
    trainingDataStartTime: Optional[Timestamp] = Optional.Absent,
    trainingDataEndTime: Optional[Timestamp] = Optional.Absent,
    evaluationDataStartTime: Optional[Timestamp] = Optional.Absent,
    evaluationDataEndTime: Optional[Timestamp] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
    ] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      Optional.Absent,
    trainingExecutionStartTime: Optional[Timestamp] = Optional.Absent,
    trainingExecutionEndTime: Optional[Timestamp] = Optional.Absent,
    failedReason: Optional[BoundedLengthString] = Optional.Absent,
    modelMetrics: Optional[ModelMetrics] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    serverSideKmsKeyId: Optional[KmsKeyArn] = Optional.Absent,
    offCondition: Optional[OffCondition] = Optional.Absent,
    sourceModelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    importJobStartTime: Optional[Timestamp] = Optional.Absent,
    importJobEndTime: Optional[Timestamp] = Optional.Absent,
    activeModelVersion: Optional[ModelVersion] = Optional.Absent,
    activeModelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    modelVersionActivatedAt: Optional[Timestamp] = Optional.Absent,
    previousActiveModelVersion: Optional[ModelVersion] = Optional.Absent,
    previousActiveModelVersionArn: Optional[ModelVersionArn] = Optional.Absent,
    previousModelVersionActivatedAt: Optional[Timestamp] = Optional.Absent,
    priorModelMetrics: Optional[ModelMetrics] = Optional.Absent,
    latestScheduledRetrainingFailedReason: Optional[BoundedLengthString] =
      Optional.Absent,
    latestScheduledRetrainingStatus: Optional[
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = Optional.Absent,
    latestScheduledRetrainingModelVersion: Optional[ModelVersion] =
      Optional.Absent,
    latestScheduledRetrainingStartTime: Optional[Timestamp] = Optional.Absent,
    latestScheduledRetrainingAvailableDataInDays: Optional[Integer] =
      Optional.Absent,
    nextScheduledRetrainingStartDate: Optional[Timestamp] = Optional.Absent,
    accumulatedInferenceDataStartTime: Optional[Timestamp] = Optional.Absent,
    accumulatedInferenceDataEndTime: Optional[Timestamp] = Optional.Absent,
    retrainingSchedulerStatus: Optional[
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse = {
    import DescribeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        schema.map(value => InlineDataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .optionallyWith(
        trainingDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataStartTime)
      .optionallyWith(
        trainingDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataEndTime)
      .optionallyWith(
        evaluationDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataStartTime)
      .optionallyWith(
        evaluationDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataEndTime)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        dataPreProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.dataPreProcessingConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        trainingExecutionStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.trainingExecutionStartTime)
      .optionallyWith(
        trainingExecutionEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingExecutionEndTime)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .optionallyWith(
        modelMetrics.map(value => ModelMetrics.unwrap(value): java.lang.String)
      )(_.modelMetrics)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        offCondition.map(value => OffCondition.unwrap(value): java.lang.String)
      )(_.offCondition)
      .optionallyWith(
        sourceModelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.sourceModelVersionArn)
      .optionallyWith(
        importJobStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.importJobStartTime)
      .optionallyWith(
        importJobEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.importJobEndTime)
      .optionallyWith(
        activeModelVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.activeModelVersion)
      .optionallyWith(
        activeModelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.activeModelVersionArn)
      .optionallyWith(
        modelVersionActivatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modelVersionActivatedAt)
      .optionallyWith(
        previousActiveModelVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.previousActiveModelVersion)
      .optionallyWith(
        previousActiveModelVersionArn.map(value =>
          ModelVersionArn.unwrap(value): java.lang.String
        )
      )(_.previousActiveModelVersionArn)
      .optionallyWith(
        previousModelVersionActivatedAt.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.previousModelVersionActivatedAt)
      .optionallyWith(
        priorModelMetrics.map(value =>
          ModelMetrics.unwrap(value): java.lang.String
        )
      )(_.priorModelMetrics)
      .optionallyWith(
        latestScheduledRetrainingFailedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.latestScheduledRetrainingFailedReason)
      .optionallyWith(
        latestScheduledRetrainingStatus.map(value => value.unwrap)
      )(_.latestScheduledRetrainingStatus)
      .optionallyWith(
        latestScheduledRetrainingModelVersion.map(value =>
          ModelVersion.unwrap(value): java.lang.Long
        )
      )(_.latestScheduledRetrainingModelVersion)
      .optionallyWith(
        latestScheduledRetrainingStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.latestScheduledRetrainingStartTime)
      .optionallyWith(
        latestScheduledRetrainingAvailableDataInDays.map(value =>
          value: java.lang.Integer
        )
      )(_.latestScheduledRetrainingAvailableDataInDays)
      .optionallyWith(
        nextScheduledRetrainingStartDate.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.nextScheduledRetrainingStartDate)
      .optionallyWith(
        accumulatedInferenceDataStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.accumulatedInferenceDataStartTime)
      .optionallyWith(
        accumulatedInferenceDataEndTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.accumulatedInferenceDataEndTime)
      .optionallyWith(retrainingSchedulerStatus.map(value => value.unwrap))(
        _.retrainingSchedulerStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeModelResponse.wrap(buildAwsValue())
}
object DescribeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeModelResponse =
      zio.aws.lookoutequipment.model.DescribeModelResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        schema.map(value => value),
        labelsInputConfiguration.map(value => value.asEditable),
        trainingDataStartTime.map(value => value),
        trainingDataEndTime.map(value => value),
        evaluationDataStartTime.map(value => value),
        evaluationDataEndTime.map(value => value),
        roleArn.map(value => value),
        dataPreProcessingConfiguration.map(value => value.asEditable),
        status.map(value => value),
        trainingExecutionStartTime.map(value => value),
        trainingExecutionEndTime.map(value => value),
        failedReason.map(value => value),
        modelMetrics.map(value => value),
        lastUpdatedTime.map(value => value),
        createdAt.map(value => value),
        serverSideKmsKeyId.map(value => value),
        offCondition.map(value => value),
        sourceModelVersionArn.map(value => value),
        importJobStartTime.map(value => value),
        importJobEndTime.map(value => value),
        activeModelVersion.map(value => value),
        activeModelVersionArn.map(value => value),
        modelVersionActivatedAt.map(value => value),
        previousActiveModelVersion.map(value => value),
        previousActiveModelVersionArn.map(value => value),
        previousModelVersionActivatedAt.map(value => value),
        priorModelMetrics.map(value => value),
        latestScheduledRetrainingFailedReason.map(value => value),
        latestScheduledRetrainingStatus.map(value => value),
        latestScheduledRetrainingModelVersion.map(value => value),
        latestScheduledRetrainingStartTime.map(value => value),
        latestScheduledRetrainingAvailableDataInDays.map(value => value),
        nextScheduledRetrainingStartDate.map(value => value),
        accumulatedInferenceDataStartTime.map(value => value),
        accumulatedInferenceDataEndTime.map(value => value),
        retrainingSchedulerStatus.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def schema: Optional[InlineDataSchema]
    def labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def trainingDataStartTime: Optional[Timestamp]
    def trainingDataEndTime: Optional[Timestamp]
    def evaluationDataStartTime: Optional[Timestamp]
    def evaluationDataEndTime: Optional[Timestamp]
    def roleArn: Optional[IamRoleArn]
    def dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ]
    def status: Optional[zio.aws.lookoutequipment.model.ModelStatus]
    def trainingExecutionStartTime: Optional[Timestamp]
    def trainingExecutionEndTime: Optional[Timestamp]
    def failedReason: Optional[BoundedLengthString]
    def modelMetrics: Optional[ModelMetrics]
    def lastUpdatedTime: Optional[Timestamp]
    def createdAt: Optional[Timestamp]
    def serverSideKmsKeyId: Optional[KmsKeyArn]
    def offCondition: Optional[OffCondition]
    def sourceModelVersionArn: Optional[ModelVersionArn]
    def importJobStartTime: Optional[Timestamp]
    def importJobEndTime: Optional[Timestamp]
    def activeModelVersion: Optional[ModelVersion]
    def activeModelVersionArn: Optional[ModelVersionArn]
    def modelVersionActivatedAt: Optional[Timestamp]
    def previousActiveModelVersion: Optional[ModelVersion]
    def previousActiveModelVersionArn: Optional[ModelVersionArn]
    def previousModelVersionActivatedAt: Optional[Timestamp]
    def priorModelMetrics: Optional[ModelMetrics]
    def latestScheduledRetrainingFailedReason: Optional[BoundedLengthString]
    def latestScheduledRetrainingStatus
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus]
    def latestScheduledRetrainingModelVersion: Optional[ModelVersion]
    def latestScheduledRetrainingStartTime: Optional[Timestamp]
    def latestScheduledRetrainingAvailableDataInDays: Optional[Integer]
    def nextScheduledRetrainingStartDate: Optional[Timestamp]
    def accumulatedInferenceDataStartTime: Optional[Timestamp]
    def accumulatedInferenceDataEndTime: Optional[Timestamp]
    def retrainingSchedulerStatus
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getTrainingDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataStartTime", trainingDataStartTime)
    def getTrainingDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataEndTime", trainingDataEndTime)
    def getEvaluationDataStartTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("evaluationDataStartTime", evaluationDataStartTime)
    def getEvaluationDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("evaluationDataEndTime", evaluationDataEndTime)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPreProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataPreProcessingConfiguration",
      dataPreProcessingConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTrainingExecutionStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "trainingExecutionStartTime",
        trainingExecutionStartTime
      )
    def getTrainingExecutionEndTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("trainingExecutionEndTime", trainingExecutionEndTime)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
    def getModelMetrics: ZIO[Any, AwsError, ModelMetrics] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getOffCondition: ZIO[Any, AwsError, OffCondition] =
      AwsError.unwrapOptionField("offCondition", offCondition)
    def getSourceModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField("sourceModelVersionArn", sourceModelVersionArn)
    def getImportJobStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("importJobStartTime", importJobStartTime)
    def getImportJobEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("importJobEndTime", importJobEndTime)
    def getActiveModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("activeModelVersion", activeModelVersion)
    def getActiveModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField("activeModelVersionArn", activeModelVersionArn)
    def getModelVersionActivatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("modelVersionActivatedAt", modelVersionActivatedAt)
    def getPreviousActiveModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField(
        "previousActiveModelVersion",
        previousActiveModelVersion
      )
    def getPreviousActiveModelVersionArn: ZIO[Any, AwsError, ModelVersionArn] =
      AwsError.unwrapOptionField(
        "previousActiveModelVersionArn",
        previousActiveModelVersionArn
      )
    def getPreviousModelVersionActivatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "previousModelVersionActivatedAt",
        previousModelVersionActivatedAt
      )
    def getPriorModelMetrics: ZIO[Any, AwsError, ModelMetrics] =
      AwsError.unwrapOptionField("priorModelMetrics", priorModelMetrics)
    def getLatestScheduledRetrainingFailedReason
        : ZIO[Any, AwsError, BoundedLengthString] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingFailedReason",
      latestScheduledRetrainingFailedReason
    )
    def getLatestScheduledRetrainingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionStatus
    ] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingStatus",
      latestScheduledRetrainingStatus
    )
    def getLatestScheduledRetrainingModelVersion
        : ZIO[Any, AwsError, ModelVersion] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingModelVersion",
      latestScheduledRetrainingModelVersion
    )
    def getLatestScheduledRetrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "latestScheduledRetrainingStartTime",
        latestScheduledRetrainingStartTime
      )
    def getLatestScheduledRetrainingAvailableDataInDays
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "latestScheduledRetrainingAvailableDataInDays",
      latestScheduledRetrainingAvailableDataInDays
    )
    def getNextScheduledRetrainingStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "nextScheduledRetrainingStartDate",
        nextScheduledRetrainingStartDate
      )
    def getAccumulatedInferenceDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "accumulatedInferenceDataStartTime",
        accumulatedInferenceDataStartTime
      )
    def getAccumulatedInferenceDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "accumulatedInferenceDataEndTime",
        accumulatedInferenceDataEndTime
      )
    def getRetrainingSchedulerStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerStatus
    ] = AwsError.unwrapOptionField(
      "retrainingSchedulerStatus",
      retrainingSchedulerStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ) extends zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val schema: Optional[InlineDataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
      )
    override val labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val trainingDataStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val trainingDataEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val evaluationDataStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationDataStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val evaluationDataEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationDataEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPreProcessingConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
          .wrap(value)
      )
    override val status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val trainingExecutionStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingExecutionStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val trainingExecutionEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingExecutionEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val failedReason: Optional[BoundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedReason())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
        )
    override val modelMetrics: Optional[ModelMetrics] = zio.aws.core.internal
      .optionalFromNullable(impl.modelMetrics())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelMetrics(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val serverSideKmsKeyId: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val offCondition: Optional[OffCondition] = zio.aws.core.internal
      .optionalFromNullable(impl.offCondition())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.OffCondition(value)
      )
    override val sourceModelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceModelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val importJobStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.importJobStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val importJobEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.importJobEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val activeModelVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val activeModelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val modelVersionActivatedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelVersionActivatedAt())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val previousActiveModelVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousActiveModelVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val previousActiveModelVersionArn: Optional[ModelVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousActiveModelVersionArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersionArn(value)
        )
    override val previousModelVersionActivatedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousModelVersionActivatedAt())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val priorModelMetrics: Optional[ModelMetrics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priorModelMetrics())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelMetrics(value)
        )
    override val latestScheduledRetrainingFailedReason
        : Optional[BoundedLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.latestScheduledRetrainingFailedReason())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
      )
    override val latestScheduledRetrainingStatus
        : Optional[zio.aws.lookoutequipment.model.ModelVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingStatus())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelVersionStatus.wrap(value)
        )
    override val latestScheduledRetrainingModelVersion: Optional[ModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingModelVersion())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.ModelVersion(value)
        )
    override val latestScheduledRetrainingStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestScheduledRetrainingStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val latestScheduledRetrainingAvailableDataInDays
        : Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.latestScheduledRetrainingAvailableDataInDays())
      .map(value => value: Integer)
    override val nextScheduledRetrainingStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextScheduledRetrainingStartDate())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val accumulatedInferenceDataStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accumulatedInferenceDataStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val accumulatedInferenceDataEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accumulatedInferenceDataEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val retrainingSchedulerStatus
        : Optional[zio.aws.lookoutequipment.model.RetrainingSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingSchedulerStatus())
        .map(value =>
          zio.aws.lookoutequipment.model.RetrainingSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ): zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    new Wrapper(impl)
}
