package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.ModelName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest = {
    import DescribeModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DescribeModelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeModelRequest.wrap(buildAwsValue())
}
object DescribeModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeModelRequest =
      zio.aws.lookoutequipment.model.DescribeModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest
  ) extends zio.aws.lookoutequipment.model.DescribeModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest
  ): zio.aws.lookoutequipment.model.DescribeModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
