package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.LabelGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLabelGroupRequest(labelGroupName: LabelGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest = {
    import DescribeLabelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeLabelGroupRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeLabelGroupRequest
      .wrap(buildAwsValue())
}
object DescribeLabelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeLabelGroupRequest =
      zio.aws.lookoutequipment.model.DescribeLabelGroupRequest(labelGroupName)
    def labelGroupName: LabelGroupName
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest
  ) extends zio.aws.lookoutequipment.model.DescribeLabelGroupRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest
  ): zio.aws.lookoutequipment.model.DescribeLabelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
