package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  DatasetArn,
  Timestamp,
  DatasetName,
  KmsKeyArn,
  InlineDataSchema
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      Optional.Absent,
    schema: Optional[InlineDataSchema] = Optional.Absent,
    serverSideKmsKeyId: Optional[KmsKeyArn] = Optional.Absent,
    ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
    ] = Optional.Absent,
    dataQualitySummary: Optional[
      zio.aws.lookoutequipment.model.DataQualitySummary
    ] = Optional.Absent,
    ingestedFilesSummary: Optional[
      zio.aws.lookoutequipment.model.IngestedFilesSummary
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    dataStartTime: Optional[Timestamp] = Optional.Absent,
    dataEndTime: Optional[Timestamp] = Optional.Absent,
    sourceDatasetArn: Optional[DatasetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        schema.map(value => InlineDataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        ingestionInputConfiguration.map(value => value.buildAwsValue())
      )(_.ingestionInputConfiguration)
      .optionallyWith(dataQualitySummary.map(value => value.buildAwsValue()))(
        _.dataQualitySummary
      )
      .optionallyWith(ingestedFilesSummary.map(value => value.buildAwsValue()))(
        _.ingestedFilesSummary
      )
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        dataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTime)
      .optionallyWith(
        dataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTime)
      .optionallyWith(
        sourceDatasetArn.map(value =>
          DatasetArn.unwrap(value): java.lang.String
        )
      )(_.sourceDatasetArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeDatasetResponse =
      zio.aws.lookoutequipment.model.DescribeDatasetResponse(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        status.map(value => value),
        schema.map(value => value),
        serverSideKmsKeyId.map(value => value),
        ingestionInputConfiguration.map(value => value.asEditable),
        dataQualitySummary.map(value => value.asEditable),
        ingestedFilesSummary.map(value => value.asEditable),
        roleArn.map(value => value),
        dataStartTime.map(value => value),
        dataEndTime.map(value => value),
        sourceDatasetArn.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def status: Optional[zio.aws.lookoutequipment.model.DatasetStatus]
    def schema: Optional[InlineDataSchema]
    def serverSideKmsKeyId: Optional[KmsKeyArn]
    def ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ]
    def dataQualitySummary
        : Optional[zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly]
    def ingestedFilesSummary
        : Optional[zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly]
    def roleArn: Optional[IamRoleArn]
    def dataStartTime: Optional[Timestamp]
    def dataEndTime: Optional[Timestamp]
    def sourceDatasetArn: Optional[DatasetArn]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getIngestionInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingestionInputConfiguration",
      ingestionInputConfiguration
    )
    def getDataQualitySummary: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly
    ] = AwsError.unwrapOptionField("dataQualitySummary", dataQualitySummary)
    def getIngestedFilesSummary: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly
    ] = AwsError.unwrapOptionField("ingestedFilesSummary", ingestedFilesSummary)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTime", dataStartTime)
    def getDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTime", dataEndTime)
    def getSourceDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("sourceDatasetArn", sourceDatasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ) extends zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.DatasetStatus.wrap(value))
    override val schema: Optional[InlineDataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
      )
    override val serverSideKmsKeyId: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ingestionInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionInputConfiguration.wrap(value)
      )
    override val dataQualitySummary
        : Optional[zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataQualitySummary())
        .map(value =>
          zio.aws.lookoutequipment.model.DataQualitySummary.wrap(value)
        )
    override val ingestedFilesSummary: Optional[
      zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ingestedFilesSummary())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestedFilesSummary.wrap(value)
      )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val dataStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val sourceDatasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDatasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ): zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly =
    new Wrapper(impl)
}
