package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest =
      zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest
  ) extends zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.lookoutequipment.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest
  ): zio.aws.lookoutequipment.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
