package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{LabelId, LabelGroupName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLabelRequest(
    labelGroupName: LabelGroupName,
    labelId: LabelId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest = {
    import DeleteLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .labelId(LabelId.unwrap(labelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DeleteLabelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteLabelRequest.wrap(buildAwsValue())
}
object DeleteLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DeleteLabelRequest =
      zio.aws.lookoutequipment.model.DeleteLabelRequest(labelGroupName, labelId)
    def labelGroupName: LabelGroupName
    def labelId: LabelId
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getLabelId: ZIO[Any, Nothing, LabelId] = ZIO.succeed(labelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest
  ) extends zio.aws.lookoutequipment.model.DeleteLabelRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val labelId: LabelId =
      zio.aws.lookoutequipment.model.primitives.LabelId(impl.labelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest
  ): zio.aws.lookoutequipment.model.DeleteLabelRequest.ReadOnly = new Wrapper(
    impl
  )
}
