package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.DatasetIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(datasetName: DatasetIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest
      .builder()
      .datasetName(DatasetIdentifier.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DeleteDatasetRequest =
      zio.aws.lookoutequipment.model.DeleteDatasetRequest(datasetName)
    def datasetName: DatasetIdentifier
    def getDatasetName: ZIO[Any, Nothing, DatasetIdentifier] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest
  ) extends zio.aws.lookoutequipment.model.DeleteDatasetRequest.ReadOnly {
    override val datasetName: DatasetIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .DatasetIdentifier(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest
  ): zio.aws.lookoutequipment.model.DeleteDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
