package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  DatasetArn,
  DatasetName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DatasetSummary(
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DatasetSummary = {
    import DatasetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DatasetSummary
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly =
    zio.aws.lookoutequipment.model.DatasetSummary.wrap(buildAwsValue())
}
object DatasetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DatasetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DatasetSummary =
      zio.aws.lookoutequipment.model.DatasetSummary(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def status: Optional[zio.aws.lookoutequipment.model.DatasetStatus]
    def createdAt: Optional[Timestamp]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DatasetSummary
  ) extends zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.DatasetStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DatasetSummary
  ): zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly = new Wrapper(impl)
}
