package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  LookbackWindow,
  Timestamp,
  IdempotenceToken,
  ModelName,
  RetrainingFrequency
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateRetrainingSchedulerRequest(
    modelName: ModelName,
    retrainingStartDate: Optional[Timestamp] = Optional.Absent,
    retrainingFrequency: RetrainingFrequency,
    lookbackWindow: LookbackWindow,
    promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      Optional.Absent,
    clientToken: IdempotenceToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest = {
    import CreateRetrainingSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        retrainingStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.retrainingStartDate)
      .retrainingFrequency(
        RetrainingFrequency.unwrap(retrainingFrequency): java.lang.String
      )
      .lookbackWindow(LookbackWindow.unwrap(lookbackWindow): java.lang.String)
      .optionallyWith(promoteMode.map(value => value.unwrap))(_.promoteMode)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest
      .wrap(buildAwsValue())
}
object CreateRetrainingSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest =
      zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest(
        modelName,
        retrainingStartDate.map(value => value),
        retrainingFrequency,
        lookbackWindow,
        promoteMode.map(value => value),
        clientToken
      )
    def modelName: ModelName
    def retrainingStartDate: Optional[Timestamp]
    def retrainingFrequency: RetrainingFrequency
    def lookbackWindow: LookbackWindow
    def promoteMode: Optional[zio.aws.lookoutequipment.model.ModelPromoteMode]
    def clientToken: IdempotenceToken
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getRetrainingStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("retrainingStartDate", retrainingStartDate)
    def getRetrainingFrequency: ZIO[Any, Nothing, RetrainingFrequency] =
      ZIO.succeed(retrainingFrequency)
    def getLookbackWindow: ZIO[Any, Nothing, LookbackWindow] =
      ZIO.succeed(lookbackWindow)
    def getPromoteMode
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelPromoteMode] =
      AwsError.unwrapOptionField("promoteMode", promoteMode)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val retrainingStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrainingStartDate())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val retrainingFrequency: RetrainingFrequency =
      zio.aws.lookoutequipment.model.primitives
        .RetrainingFrequency(impl.retrainingFrequency())
    override val lookbackWindow: LookbackWindow =
      zio.aws.lookoutequipment.model.primitives
        .LookbackWindow(impl.lookbackWindow())
    override val promoteMode
        : Optional[zio.aws.lookoutequipment.model.ModelPromoteMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promoteMode())
        .map(value =>
          zio.aws.lookoutequipment.model.ModelPromoteMode.wrap(value)
        )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest
  ): zio.aws.lookoutequipment.model.CreateRetrainingSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
