package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.ModelArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelResponse(
    modelArn: Optional[ModelArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse = {
    import CreateModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly =
    zio.aws.lookoutequipment.model.CreateModelResponse.wrap(buildAwsValue())
}
object CreateModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateModelResponse =
      zio.aws.lookoutequipment.model.CreateModelResponse(
        modelArn.map(value => value),
        status.map(value => value)
      )
    def modelArn: Optional[ModelArn]
    def status: Optional[zio.aws.lookoutequipment.model.ModelStatus]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse
  ) extends zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly {
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse
  ): zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
