package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  FaultCode,
  Comments,
  Equipment,
  IdempotenceToken,
  LabelGroupName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateLabelRequest(
    labelGroupName: LabelGroupName,
    startTime: Timestamp,
    endTime: Timestamp,
    rating: zio.aws.lookoutequipment.model.LabelRating,
    faultCode: Optional[FaultCode] = Optional.Absent,
    notes: Optional[Comments] = Optional.Absent,
    equipment: Optional[Equipment] = Optional.Absent,
    clientToken: IdempotenceToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest = {
    import CreateLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .rating(rating.unwrap)
      .optionallyWith(
        faultCode.map(value => FaultCode.unwrap(value): java.lang.String)
      )(_.faultCode)
      .optionallyWith(
        notes.map(value => Comments.unwrap(value): java.lang.String)
      )(_.notes)
      .optionallyWith(
        equipment.map(value => Equipment.unwrap(value): java.lang.String)
      )(_.equipment)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CreateLabelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateLabelRequest.wrap(buildAwsValue())
}
object CreateLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateLabelRequest =
      zio.aws.lookoutequipment.model.CreateLabelRequest(
        labelGroupName,
        startTime,
        endTime,
        rating,
        faultCode.map(value => value),
        notes.map(value => value),
        equipment.map(value => value),
        clientToken
      )
    def labelGroupName: LabelGroupName
    def startTime: Timestamp
    def endTime: Timestamp
    def rating: zio.aws.lookoutequipment.model.LabelRating
    def faultCode: Optional[FaultCode]
    def notes: Optional[Comments]
    def equipment: Optional[Equipment]
    def clientToken: IdempotenceToken
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getRating
        : ZIO[Any, Nothing, zio.aws.lookoutequipment.model.LabelRating] =
      ZIO.succeed(rating)
    def getFaultCode: ZIO[Any, AwsError, FaultCode] =
      AwsError.unwrapOptionField("faultCode", faultCode)
    def getNotes: ZIO[Any, AwsError, Comments] =
      AwsError.unwrapOptionField("notes", notes)
    def getEquipment: ZIO[Any, AwsError, Equipment] =
      AwsError.unwrapOptionField("equipment", equipment)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest
  ) extends zio.aws.lookoutequipment.model.CreateLabelRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val startTime: Timestamp =
      zio.aws.lookoutequipment.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.lookoutequipment.model.primitives.Timestamp(impl.endTime())
    override val rating: zio.aws.lookoutequipment.model.LabelRating =
      zio.aws.lookoutequipment.model.LabelRating.wrap(impl.rating())
    override val faultCode: Optional[FaultCode] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCode())
      .map(value => zio.aws.lookoutequipment.model.primitives.FaultCode(value))
    override val notes: Optional[Comments] = zio.aws.core.internal
      .optionalFromNullable(impl.notes())
      .map(value => zio.aws.lookoutequipment.model.primitives.Comments(value))
    override val equipment: Optional[Equipment] = zio.aws.core.internal
      .optionalFromNullable(impl.equipment())
      .map(value => zio.aws.lookoutequipment.model.primitives.Equipment(value))
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest
  ): zio.aws.lookoutequipment.model.CreateLabelRequest.ReadOnly = new Wrapper(
    impl
  )
}
