package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  InferenceSchedulerName,
  InferenceSchedulerArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInferenceSchedulerResponse(
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse = {
    import CreateInferenceSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse
      .builder()
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse
      .wrap(buildAwsValue())
}
object CreateInferenceSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse =
      zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse(
        inferenceSchedulerArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        status.map(value => value)
      )
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly {
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse
  ): zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
