package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  DataDelayOffsetInMinutes,
  NameOrArn,
  InferenceSchedulerName,
  IdempotenceToken,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInferenceSchedulerRequest(
    modelName: ModelName,
    inferenceSchedulerName: InferenceSchedulerName,
    dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      Optional.Absent,
    dataUploadFrequency: zio.aws.lookoutequipment.model.DataUploadFrequency,
    dataInputConfiguration: zio.aws.lookoutequipment.model.InferenceInputConfiguration,
    dataOutputConfiguration: zio.aws.lookoutequipment.model.InferenceOutputConfiguration,
    roleArn: IamRoleArn,
    serverSideKmsKeyId: Optional[NameOrArn] = Optional.Absent,
    clientToken: IdempotenceToken,
    tags: Optional[Iterable[zio.aws.lookoutequipment.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest = {
    import CreateInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .inferenceSchedulerName(
        InferenceSchedulerName.unwrap(inferenceSchedulerName): java.lang.String
      )
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .dataUploadFrequency(dataUploadFrequency.unwrap)
      .dataInputConfiguration(dataInputConfiguration.buildAwsValue())
      .dataOutputConfiguration(dataOutputConfiguration.buildAwsValue())
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          NameOrArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object CreateInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest(
        modelName,
        inferenceSchedulerName,
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency,
        dataInputConfiguration.asEditable,
        dataOutputConfiguration.asEditable,
        roleArn,
        serverSideKmsKeyId.map(value => value),
        clientToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelName: ModelName
    def inferenceSchedulerName: InferenceSchedulerName
    def dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes]
    def dataUploadFrequency: zio.aws.lookoutequipment.model.DataUploadFrequency
    def dataInputConfiguration
        : zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    def dataOutputConfiguration
        : zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    def roleArn: IamRoleArn
    def serverSideKmsKeyId: Optional[NameOrArn]
    def clientToken: IdempotenceToken
    def tags: Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getInferenceSchedulerName: ZIO[Any, Nothing, InferenceSchedulerName] =
      ZIO.succeed(inferenceSchedulerName)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = ZIO.succeed(dataUploadFrequency)
    def getDataInputConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = ZIO.succeed(dataInputConfiguration)
    def getDataOutputConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = ZIO.succeed(dataOutputConfiguration)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val inferenceSchedulerName: InferenceSchedulerName =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerName(impl.inferenceSchedulerName())
    override val dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : zio.aws.lookoutequipment.model.DataUploadFrequency =
      zio.aws.lookoutequipment.model.DataUploadFrequency
        .wrap(impl.dataUploadFrequency())
    override val dataInputConfiguration
        : zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly =
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
        .wrap(impl.dataInputConfiguration())
    override val dataOutputConfiguration
        : zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly =
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
        .wrap(impl.dataOutputConfiguration())
    override val roleArn: IamRoleArn =
      zio.aws.lookoutequipment.model.primitives.IamRoleArn(impl.roleArn())
    override val serverSideKmsKeyId: Optional[NameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val tags
        : Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.CreateInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
