package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CountPercent(count: Integer, percentage: Float) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CountPercent = {
    import CountPercent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CountPercent
      .builder()
      .count(count: java.lang.Integer)
      .percentage(percentage: java.lang.Float)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CountPercent.ReadOnly =
    zio.aws.lookoutequipment.model.CountPercent.wrap(buildAwsValue())
}
object CountPercent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CountPercent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CountPercent =
      zio.aws.lookoutequipment.model.CountPercent(count, percentage)
    def count: Integer
    def percentage: Float
    def getCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(count)
    def getPercentage: ZIO[Any, Nothing, Float] = ZIO.succeed(percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CountPercent
  ) extends zio.aws.lookoutequipment.model.CountPercent.ReadOnly {
    override val count: Integer = impl.count(): Integer
    override val percentage: Float = impl.percentage(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CountPercent
  ): zio.aws.lookoutequipment.model.CountPercent.ReadOnly = new Wrapper(impl)
}
