package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait AutoPromotionResult {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult
}
object AutoPromotionResult {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult
  ): zio.aws.lookoutequipment.model.AutoPromotionResult = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.MODEL_PROMOTED =>
      val r = MODEL_PROMOTED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.MODEL_NOT_PROMOTED =>
      val r = MODEL_NOT_PROMOTED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_INTERNAL_ERROR =>
      val r = RETRAINING_INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_CUSTOMER_ERROR =>
      val r = RETRAINING_CUSTOMER_ERROR
      r
    case software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_CANCELLED =>
      val r = RETRAINING_CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.UNKNOWN_TO_SDK_VERSION
  }
  case object MODEL_PROMOTED
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.MODEL_PROMOTED
  }
  case object MODEL_NOT_PROMOTED
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.MODEL_NOT_PROMOTED
  }
  case object RETRAINING_INTERNAL_ERROR
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_INTERNAL_ERROR
  }
  case object RETRAINING_CUSTOMER_ERROR
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_CUSTOMER_ERROR
  }
  case object RETRAINING_CANCELLED
      extends zio.aws.lookoutequipment.model.AutoPromotionResult {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult =
      software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult.RETRAINING_CANCELLED
  }
}
