package zio.aws.lookoutequipment
import zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly
import zio.aws.lookoutequipment.model.{
  DescribeModelVersionRequest,
  StopRetrainingSchedulerRequest,
  CreateDatasetRequest,
  StartInferenceSchedulerRequest,
  DescribeLabelGroupRequest,
  DeleteLabelRequest,
  DescribeRetrainingSchedulerRequest,
  PutResourcePolicyRequest,
  ImportDatasetRequest,
  CreateLabelRequest,
  ListLabelGroupsRequest,
  CreateInferenceSchedulerRequest,
  DeleteLabelGroupRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DescribeInferenceSchedulerRequest,
  ListInferenceEventsRequest,
  ListRetrainingSchedulersRequest,
  ListInferenceSchedulersRequest,
  ListDatasetsRequest,
  ListSensorStatisticsRequest,
  ListLabelsRequest,
  ListModelsRequest,
  DescribeLabelRequest,
  CreateRetrainingSchedulerRequest,
  StartRetrainingSchedulerRequest,
  UpdateLabelGroupRequest,
  UpdateInferenceSchedulerRequest,
  DeleteDatasetRequest,
  DeleteInferenceSchedulerRequest,
  DeleteResourcePolicyRequest,
  StartDataIngestionJobRequest,
  UntagResourceRequest,
  ListInferenceExecutionsRequest,
  UpdateActiveModelVersionRequest,
  ListModelVersionsRequest,
  DescribeDataIngestionJobRequest,
  UpdateRetrainingSchedulerRequest,
  CreateLabelGroupRequest,
  DeleteRetrainingSchedulerRequest,
  UpdateModelRequest,
  DeleteModelRequest,
  ListDataIngestionJobsRequest,
  StopInferenceSchedulerRequest,
  DescribeResourcePolicyRequest,
  ImportModelVersionRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object LookoutEquipmentMock extends Mock[LookoutEquipment] {
  object ListInferenceExecutions
      extends Stream[
        ListInferenceExecutionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
      ]
  object ListInferenceExecutionsPaginated
      extends Effect[
        ListInferenceExecutionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
      ]
  object ListModels
      extends Stream[
        ListModelsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
      ]
  object ListModelsPaginated
      extends Effect[ListModelsRequest, AwsError, ReadOnly]
  object ImportModelVersion
      extends Effect[
        ImportModelVersionRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly
      ]
  object StartInferenceScheduler
      extends Effect[
        StartInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
      ]
  object ListInferenceEvents
      extends Stream[
        ListInferenceEventsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
      ]
  object ListInferenceEventsPaginated
      extends Effect[
        ListInferenceEventsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly
      ]
  object ListLabels
      extends Stream[
        ListLabelsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
      ]
  object ListLabelsPaginated
      extends Effect[
        ListLabelsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
      ]
  object UpdateModel extends Effect[UpdateModelRequest, AwsError, Unit]
  object DescribeLabelGroup
      extends Effect[
        DescribeLabelGroupRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly
      ]
  object StartRetrainingScheduler
      extends Effect[
        StartRetrainingSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly
      ]
  object StopRetrainingScheduler
      extends Effect[
        StopRetrainingSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.ReadOnly
      ]
  object ListLabelGroups
      extends Stream[
        ListLabelGroupsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
      ]
  object ListLabelGroupsPaginated
      extends Effect[
        ListLabelGroupsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly
      ]
  object DeleteRetrainingScheduler
      extends Effect[DeleteRetrainingSchedulerRequest, AwsError, Unit]
  object StopInferenceScheduler
      extends Effect[
        StopInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
      ]
  object DeleteLabel extends Effect[DeleteLabelRequest, AwsError, Unit]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
      ]
  object DeleteModel extends Effect[DeleteModelRequest, AwsError, Unit]
  object CreateRetrainingScheduler
      extends Effect[
        CreateRetrainingSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.ReadOnly
      ]
  object CreateInferenceScheduler
      extends Effect[
        CreateInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
      ]
  object ImportDataset
      extends Effect[
        ImportDatasetRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeLabel
      extends Effect[
        DescribeLabelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeLabelResponse.ReadOnly
      ]
  object DescribeInferenceScheduler
      extends Effect[
        DescribeInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
      ]
  object UpdateLabelGroup
      extends Effect[UpdateLabelGroupRequest, AwsError, Unit]
  object DescribeRetrainingScheduler
      extends Effect[
        DescribeRetrainingSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly
      ]
  object DeleteInferenceScheduler
      extends Effect[DeleteInferenceSchedulerRequest, AwsError, Unit]
  object DeleteResourcePolicy
      extends Effect[DeleteResourcePolicyRequest, AwsError, Unit]
  object ListSensorStatistics
      extends Stream[
        ListSensorStatisticsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
      ]
  object ListSensorStatisticsPaginated
      extends Effect[
        ListSensorStatisticsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateInferenceScheduler
      extends Effect[UpdateInferenceSchedulerRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
      ]
  object CreateLabelGroup
      extends Effect[
        CreateLabelGroupRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly
      ]
  object ListRetrainingSchedulers
      extends Stream[
        ListRetrainingSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
      ]
  object ListRetrainingSchedulersPaginated
      extends Effect[
        ListRetrainingSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly
      ]
  object CreateLabel
      extends Effect[
        CreateLabelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly
      ]
  object DescribeResourcePolicy
      extends Effect[
        DescribeResourcePolicyRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly
      ]
  object ListModelVersions
      extends Stream[
        ListModelVersionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
      ]
  object ListModelVersionsPaginated
      extends Effect[
        ListModelVersionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly
      ]
  object UpdateRetrainingScheduler
      extends Effect[UpdateRetrainingSchedulerRequest, AwsError, Unit]
  object DeleteLabelGroup
      extends Effect[DeleteLabelGroupRequest, AwsError, Unit]
  object DeleteDataset extends Effect[DeleteDatasetRequest, AwsError, Unit]
  object UpdateActiveModelVersion
      extends Effect[
        UpdateActiveModelVersionRequest,
        AwsError,
        zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly
      ]
  object StartDataIngestionJob
      extends Effect[
        StartDataIngestionJobRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
      ]
  object ListInferenceSchedulers
      extends Stream[
        ListInferenceSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
      ]
  object ListInferenceSchedulersPaginated
      extends Effect[
        ListInferenceSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
      ]
  object DescribeDataIngestionJob
      extends Effect[
        DescribeDataIngestionJobRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
      ]
  object ListDataIngestionJobs
      extends Stream[
        ListDataIngestionJobsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
      ]
  object ListDataIngestionJobsPaginated
      extends Effect[
        ListDataIngestionJobsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
      ]
  object DescribeModel
      extends Effect[
        DescribeModelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
      ]
  object DescribeModelVersion
      extends Effect[
        DescribeModelVersionRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeModelVersionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LookoutEquipment] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, LookoutEquipment] { rts =>
        zio.ZIO.succeed {
          new LookoutEquipment {
            val api: LookoutEquipmentAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): LookoutEquipment = this
            def listInferenceExecutions(
                request: ListInferenceExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceExecutionsPaginated(
                request: ListInferenceExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
            ] = proxy(ListInferenceExecutionsPaginated, request)
            def createDataset(request: CreateDatasetRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
            ] = proxy(CreateDataset, request)
            def listModels(request: ListModelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelsPaginated(
                request: ListModelsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListModelsPaginated, request)
            def importModelVersion(request: ImportModelVersionRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly
            ] = proxy(ImportModelVersion, request)
            def startInferenceScheduler(
                request: StartInferenceSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
            ] = proxy(StartInferenceScheduler, request)
            def listInferenceEvents(
                request: ListInferenceEventsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceEvents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceEventsPaginated(
                request: ListInferenceEventsRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly
            ] = proxy(ListInferenceEventsPaginated, request)
            def listLabels(request: ListLabelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLabels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLabelsPaginated(request: ListLabelsRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly
            ] = proxy(ListLabelsPaginated, request)
            def createModel(request: CreateModelRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
            ] = proxy(CreateModel, request)
            def updateModel(request: UpdateModelRequest): IO[AwsError, Unit] =
              proxy(UpdateModel, request)
            def describeLabelGroup(request: DescribeLabelGroupRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly
            ] = proxy(DescribeLabelGroup, request)
            def startRetrainingScheduler(
                request: StartRetrainingSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly
            ] = proxy(StartRetrainingScheduler, request)
            def stopRetrainingScheduler(
                request: StopRetrainingSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.ReadOnly
            ] = proxy(StopRetrainingScheduler, request)
            def listLabelGroups(request: ListLabelGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLabelGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLabelGroupsPaginated(request: ListLabelGroupsRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly
            ] = proxy(ListLabelGroupsPaginated, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def deleteRetrainingScheduler(
                request: DeleteRetrainingSchedulerRequest
            ): IO[AwsError, Unit] = proxy(DeleteRetrainingScheduler, request)
            def stopInferenceScheduler(
                request: StopInferenceSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
            ] = proxy(StopInferenceScheduler, request)
            def deleteLabel(request: DeleteLabelRequest): IO[AwsError, Unit] =
              proxy(DeleteLabel, request)
            def describeDataset(request: DescribeDatasetRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
            ] = proxy(DescribeDataset, request)
            def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
              proxy(DeleteModel, request)
            def createRetrainingScheduler(
                request: CreateRetrainingSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.ReadOnly
            ] = proxy(CreateRetrainingScheduler, request)
            def createInferenceScheduler(
                request: CreateInferenceSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
            ] = proxy(CreateInferenceScheduler, request)
            def importDataset(request: ImportDatasetRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly
            ] = proxy(ImportDataset, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeLabel(request: DescribeLabelRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeLabelResponse.ReadOnly
            ] = proxy(DescribeLabel, request)
            def describeInferenceScheduler(
                request: DescribeInferenceSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
            ] = proxy(DescribeInferenceScheduler, request)
            def updateLabelGroup(
                request: UpdateLabelGroupRequest
            ): IO[AwsError, Unit] = proxy(UpdateLabelGroup, request)
            def describeRetrainingScheduler(
                request: DescribeRetrainingSchedulerRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly
            ] = proxy(DescribeRetrainingScheduler, request)
            def deleteInferenceScheduler(
                request: DeleteInferenceSchedulerRequest
            ): IO[AwsError, Unit] = proxy(DeleteInferenceScheduler, request)
            def deleteResourcePolicy(
                request: DeleteResourcePolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteResourcePolicy, request)
            def listSensorStatistics(
                request: ListSensorStatisticsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSensorStatistics, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSensorStatisticsPaginated(
                request: ListSensorStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly
            ] = proxy(ListSensorStatisticsPaginated, request)
            def listDatasets(request: ListDatasetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetsPaginated(request: ListDatasetsRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
            ] = proxy(ListDatasetsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def updateInferenceScheduler(
                request: UpdateInferenceSchedulerRequest
            ): IO[AwsError, Unit] = proxy(UpdateInferenceScheduler, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createLabelGroup(request: CreateLabelGroupRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly
            ] = proxy(CreateLabelGroup, request)
            def listRetrainingSchedulers(
                request: ListRetrainingSchedulersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRetrainingSchedulers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRetrainingSchedulersPaginated(
                request: ListRetrainingSchedulersRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly
            ] = proxy(ListRetrainingSchedulersPaginated, request)
            def createLabel(request: CreateLabelRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly
            ] = proxy(CreateLabel, request)
            def describeResourcePolicy(
                request: DescribeResourcePolicyRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly
            ] = proxy(DescribeResourcePolicy, request)
            def listModelVersions(request: ListModelVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelVersionsPaginated(
                request: ListModelVersionsRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly
            ] = proxy(ListModelVersionsPaginated, request)
            def updateRetrainingScheduler(
                request: UpdateRetrainingSchedulerRequest
            ): IO[AwsError, Unit] = proxy(UpdateRetrainingScheduler, request)
            def deleteLabelGroup(
                request: DeleteLabelGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteLabelGroup, request)
            def deleteDataset(
                request: DeleteDatasetRequest
            ): IO[AwsError, Unit] = proxy(DeleteDataset, request)
            def updateActiveModelVersion(
                request: UpdateActiveModelVersionRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly
            ] = proxy(UpdateActiveModelVersion, request)
            def startDataIngestionJob(
                request: StartDataIngestionJobRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
            ] = proxy(StartDataIngestionJob, request)
            def listInferenceSchedulers(
                request: ListInferenceSchedulersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceSchedulers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceSchedulersPaginated(
                request: ListInferenceSchedulersRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
            ] = proxy(ListInferenceSchedulersPaginated, request)
            def describeDataIngestionJob(
                request: DescribeDataIngestionJobRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
            ] = proxy(DescribeDataIngestionJob, request)
            def listDataIngestionJobs(
                request: ListDataIngestionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataIngestionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataIngestionJobsPaginated(
                request: ListDataIngestionJobsRequest
            ): IO[
              AwsError,
              zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
            ] = proxy(ListDataIngestionJobsPaginated, request)
            def describeModel(request: DescribeModelRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
            ] = proxy(DescribeModel, request)
            def describeModelVersion(request: DescribeModelVersionRequest): IO[
              AwsError,
              zio.aws.lookoutequipment.model.DescribeModelVersionResponse.ReadOnly
            ] = proxy(DescribeModelVersion, request)
          }
        }
      }
    }
  }
}
