package zio.aws.lookoutequipment
import zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.lookoutequipment.model.{
  DescribeModelVersionRequest,
  StopRetrainingSchedulerRequest,
  CreateDatasetRequest,
  StartInferenceSchedulerRequest,
  DescribeLabelGroupRequest,
  DeleteLabelRequest,
  DescribeRetrainingSchedulerRequest,
  PutResourcePolicyRequest,
  ImportDatasetRequest,
  CreateLabelRequest,
  ListLabelGroupsRequest,
  CreateInferenceSchedulerRequest,
  DeleteLabelGroupRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DescribeInferenceSchedulerRequest,
  ListInferenceEventsRequest,
  ListRetrainingSchedulersRequest,
  ListInferenceSchedulersRequest,
  ListDatasetsRequest,
  ListSensorStatisticsRequest,
  ListLabelsRequest,
  ListModelsRequest,
  DescribeLabelRequest,
  CreateRetrainingSchedulerRequest,
  StartRetrainingSchedulerRequest,
  UpdateLabelGroupRequest,
  UpdateInferenceSchedulerRequest,
  DeleteDatasetRequest,
  DeleteInferenceSchedulerRequest,
  DeleteResourcePolicyRequest,
  StartDataIngestionJobRequest,
  UntagResourceRequest,
  ListInferenceExecutionsRequest,
  UpdateActiveModelVersionRequest,
  ListModelVersionsRequest,
  DescribeDataIngestionJobRequest,
  UpdateRetrainingSchedulerRequest,
  CreateLabelGroupRequest,
  DeleteRetrainingSchedulerRequest,
  UpdateModelRequest,
  DeleteModelRequest,
  ListDataIngestionJobsRequest,
  StopInferenceSchedulerRequest,
  DescribeResourcePolicyRequest,
  ImportModelVersionRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.lookoutequipment.{
  LookoutEquipmentAsyncClientBuilder,
  LookoutEquipmentAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lookoutequipment.model.{
  InferenceSchedulerSummary,
  UpdateActiveModelVersionResponse,
  CreateLabelResponse,
  ModelSummary,
  ListInferenceEventsResponse,
  DatasetSummary,
  DataIngestionJobSummary,
  DescribeDatasetResponse,
  RetrainingSchedulerSummary,
  ListInferenceExecutionsResponse,
  PutResourcePolicyResponse,
  LabelSummary,
  ListRetrainingSchedulersResponse,
  DescribeResourcePolicyResponse,
  ModelVersionSummary,
  CreateInferenceSchedulerResponse,
  DeleteRetrainingSchedulerResponse,
  ListModelVersionsResponse,
  ListLabelsResponse,
  DescribeLabelGroupResponse,
  CreateLabelGroupResponse,
  ListInferenceSchedulersResponse,
  UpdateRetrainingSchedulerResponse,
  CreateDatasetResponse,
  DescribeModelVersionResponse,
  StartDataIngestionJobResponse,
  ImportModelVersionResponse,
  ImportDatasetResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeRetrainingSchedulerResponse,
  DeleteLabelResponse,
  DeleteModelResponse,
  StopInferenceSchedulerResponse,
  LabelGroupSummary,
  DescribeLabelResponse,
  DescribeDataIngestionJobResponse,
  ListSensorStatisticsResponse,
  UpdateModelResponse,
  DeleteDatasetResponse,
  ListModelsResponse,
  ListDataIngestionJobsResponse,
  SensorStatisticsSummary,
  CreateModelResponse,
  DeleteLabelGroupResponse,
  UpdateInferenceSchedulerResponse,
  InferenceExecutionSummary,
  StartInferenceSchedulerResponse,
  ListDatasetsResponse,
  UpdateLabelGroupResponse,
  InferenceEventSummary,
  DescribeModelResponse,
  DeleteInferenceSchedulerResponse,
  DescribeInferenceSchedulerResponse,
  StopRetrainingSchedulerResponse,
  DeleteResourcePolicyResponse,
  StartRetrainingSchedulerResponse,
  TagResourceResponse,
  ListLabelGroupsResponse,
  CreateRetrainingSchedulerResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait LookoutEquipment extends AspectSupport[LookoutEquipment] {
  val api: LookoutEquipmentAsyncClient
  def listInferenceExecutions(request: ListInferenceExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
  ]
  def listInferenceExecutionsPaginated(
      request: ListInferenceExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
  ]
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly]
  def listModels(request: ListModelsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
  ]
  def listModelsPaginated(request: ListModelsRequest): IO[AwsError, ReadOnly]
  def importModelVersion(request: ImportModelVersionRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly
  ]
  def startInferenceScheduler(request: StartInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
  ]
  def listInferenceEvents(request: ListInferenceEventsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
  ]
  def listInferenceEventsPaginated(request: ListInferenceEventsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly
  ]
  def listLabels(request: ListLabelsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
  ]
  def listLabelsPaginated(
      request: ListLabelsRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly]
  def createModel(
      request: CreateModelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly]
  def updateModel(request: UpdateModelRequest): IO[AwsError, Unit]
  def describeLabelGroup(request: DescribeLabelGroupRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly
  ]
  def startRetrainingScheduler(request: StartRetrainingSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly
  ]
  def stopRetrainingScheduler(request: StopRetrainingSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.ReadOnly
  ]
  def listLabelGroups(request: ListLabelGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
  ]
  def listLabelGroupsPaginated(request: ListLabelGroupsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly
  ]
  def putResourcePolicy(request: PutResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly
  ]
  def deleteRetrainingScheduler(
      request: DeleteRetrainingSchedulerRequest
  ): IO[AwsError, Unit]
  def stopInferenceScheduler(request: StopInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
  ]
  def deleteLabel(request: DeleteLabelRequest): IO[AwsError, Unit]
  def describeDataset(request: DescribeDatasetRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
  ]
  def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit]
  def createRetrainingScheduler(request: CreateRetrainingSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.ReadOnly
  ]
  def createInferenceScheduler(request: CreateInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
  ]
  def importDataset(
      request: ImportDatasetRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly]
  def describeLabel(
      request: DescribeLabelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.DescribeLabelResponse.ReadOnly]
  def describeInferenceScheduler(
      request: DescribeInferenceSchedulerRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
  ]
  def updateLabelGroup(request: UpdateLabelGroupRequest): IO[AwsError, Unit]
  def describeRetrainingScheduler(
      request: DescribeRetrainingSchedulerRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly
  ]
  def deleteInferenceScheduler(
      request: DeleteInferenceSchedulerRequest
  ): IO[AwsError, Unit]
  def deleteResourcePolicy(
      request: DeleteResourcePolicyRequest
  ): IO[AwsError, Unit]
  def listSensorStatistics(request: ListSensorStatisticsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
  ]
  def listSensorStatisticsPaginated(request: ListSensorStatisticsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly
  ]
  def listDatasets(request: ListDatasetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
  ]
  def listDatasetsPaginated(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateInferenceScheduler(
      request: UpdateInferenceSchedulerRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly]
  def createLabelGroup(request: CreateLabelGroupRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly
  ]
  def listRetrainingSchedulers(
      request: ListRetrainingSchedulersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
  ]
  def listRetrainingSchedulersPaginated(
      request: ListRetrainingSchedulersRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly
  ]
  def createLabel(
      request: CreateLabelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly]
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly
  ]
  def listModelVersions(request: ListModelVersionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
  ]
  def listModelVersionsPaginated(request: ListModelVersionsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly
  ]
  def updateRetrainingScheduler(
      request: UpdateRetrainingSchedulerRequest
  ): IO[AwsError, Unit]
  def deleteLabelGroup(request: DeleteLabelGroupRequest): IO[AwsError, Unit]
  def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit]
  def updateActiveModelVersion(request: UpdateActiveModelVersionRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly
  ]
  def startDataIngestionJob(request: StartDataIngestionJobRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
  ]
  def listInferenceSchedulers(request: ListInferenceSchedulersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
  ]
  def listInferenceSchedulersPaginated(
      request: ListInferenceSchedulersRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
  ]
  def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
  ]
  def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
  ]
  def listDataIngestionJobsPaginated(request: ListDataIngestionJobsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
  ]
  def describeModel(
      request: DescribeModelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly]
  def describeModelVersion(request: DescribeModelVersionRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeModelVersionResponse.ReadOnly
  ]
}
object LookoutEquipment {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LookoutEquipment] =
    customized(identity)
  def customized(
      customization: LookoutEquipmentAsyncClientBuilder => LookoutEquipmentAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LookoutEquipment] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LookoutEquipmentAsyncClientBuilder => LookoutEquipmentAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, LookoutEquipment] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LookoutEquipmentAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      LookoutEquipmentAsyncClient,
      LookoutEquipmentAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      LookoutEquipmentAsyncClient,
      LookoutEquipmentAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new LookoutEquipmentImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LookoutEquipmentImpl[R](
      override val api: LookoutEquipmentAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LookoutEquipment
      with AwsServiceBase[R] {
    override val serviceName: String = "LookoutEquipment"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LookoutEquipmentImpl[R1] = new LookoutEquipmentImpl(api, newAspect, r)
    def listInferenceExecutions(
        request: ListInferenceExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest,
      ListInferenceExecutionsResponse,
      InferenceExecutionSummary
    ](
      "listInferenceExecutions",
      api.listInferenceExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceExecutionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.InferenceExecutionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceExecutionsPaginated(
        request: ListInferenceExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest,
      ListInferenceExecutionsResponse
    ]("listInferenceExecutions", api.listInferenceExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.wrap)
      .provideEnvironment(r)
    def createDataset(request: CreateDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest,
      CreateDatasetResponse
    ]("createDataset", api.createDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateDatasetResponse.wrap)
      .provideEnvironment(r)
    def listModels(request: ListModelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest,
      ListModelsResponse,
      ModelSummary
    ](
      "listModels",
      api.listModels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.ModelSummary.wrap(item))
      .provideEnvironment(r)
    def listModelsPaginated(
        request: ListModelsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest,
      ListModelsResponse
    ]("listModels", api.listModels)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListModelsResponse.wrap)
      .provideEnvironment(r)
    def importModelVersion(request: ImportModelVersionRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest,
      ImportModelVersionResponse
    ]("importModelVersion", api.importModelVersion)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ImportModelVersionResponse.wrap)
      .provideEnvironment(r)
    def startInferenceScheduler(request: StartInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest,
      StartInferenceSchedulerResponse
    ]("startInferenceScheduler", api.startInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def listInferenceEvents(request: ListInferenceEventsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest,
      ListInferenceEventsResponse,
      InferenceEventSummary
    ](
      "listInferenceEvents",
      api.listInferenceEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceEventSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.InferenceEventSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceEventsPaginated(request: ListInferenceEventsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest,
      ListInferenceEventsResponse
    ]("listInferenceEvents", api.listInferenceEvents)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListInferenceEventsResponse.wrap)
      .provideEnvironment(r)
    def listLabels(request: ListLabelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest,
      ListLabelsResponse,
      LabelSummary
    ](
      "listLabels",
      api.listLabels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.labelSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.LabelSummary.wrap(item))
      .provideEnvironment(r)
    def listLabelsPaginated(request: ListLabelsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest,
      ListLabelsResponse
    ]("listLabels", api.listLabels)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListLabelsResponse.wrap)
      .provideEnvironment(r)
    def createModel(request: CreateModelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest,
      CreateModelResponse
    ]("createModel", api.createModel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateModelResponse.wrap)
      .provideEnvironment(r)
    def updateModel(request: UpdateModelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest,
        UpdateModelResponse
      ]("updateModel", api.updateModel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeLabelGroup(request: DescribeLabelGroupRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest,
      DescribeLabelGroupResponse
    ]("describeLabelGroup", api.describeLabelGroup)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.wrap)
      .provideEnvironment(r)
    def startRetrainingScheduler(request: StartRetrainingSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerRequest,
      StartRetrainingSchedulerResponse
    ]("startRetrainingScheduler", api.startRetrainingScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.wrap)
      .provideEnvironment(r)
    def stopRetrainingScheduler(request: StopRetrainingSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerRequest,
      StopRetrainingSchedulerResponse
    ]("stopRetrainingScheduler", api.stopRetrainingScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.wrap)
      .provideEnvironment(r)
    def listLabelGroups(request: ListLabelGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest,
      ListLabelGroupsResponse,
      LabelGroupSummary
    ](
      "listLabelGroups",
      api.listLabelGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.labelGroupSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.LabelGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listLabelGroupsPaginated(request: ListLabelGroupsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest,
      ListLabelGroupsResponse
    ]("listLabelGroups", api.listLabelGroups)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListLabelGroupsResponse.wrap)
      .provideEnvironment(r)
    def putResourcePolicy(request: PutResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest,
      PutResourcePolicyResponse
    ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.PutResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteRetrainingScheduler(
        request: DeleteRetrainingSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerRequest,
      DeleteRetrainingSchedulerResponse
    ]("deleteRetrainingScheduler", api.deleteRetrainingScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def stopInferenceScheduler(request: StopInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest,
      StopInferenceSchedulerResponse
    ]("stopInferenceScheduler", api.stopInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def deleteLabel(request: DeleteLabelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest,
        DeleteLabelResponse
      ]("deleteLabel", api.deleteLabel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeDataset(request: DescribeDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest,
      DescribeDatasetResponse
    ]("describeDataset", api.describeDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest,
        DeleteModelResponse
      ]("deleteModel", api.deleteModel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createRetrainingScheduler(
        request: CreateRetrainingSchedulerRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest,
      CreateRetrainingSchedulerResponse
    ]("createRetrainingScheduler", api.createRetrainingScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.wrap)
      .provideEnvironment(r)
    def createInferenceScheduler(request: CreateInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest,
      CreateInferenceSchedulerResponse
    ]("createInferenceScheduler", api.createInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def importDataset(request: ImportDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest,
      ImportDatasetResponse
    ]("importDataset", api.importDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ImportDatasetResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeLabel(request: DescribeLabelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeLabelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest,
      DescribeLabelResponse
    ]("describeLabel", api.describeLabel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeLabelResponse.wrap)
      .provideEnvironment(r)
    def describeInferenceScheduler(
        request: DescribeInferenceSchedulerRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest,
      DescribeInferenceSchedulerResponse
    ]("describeInferenceScheduler", api.describeInferenceScheduler)(
      request.buildAwsValue()
    ).map(
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.wrap
    ).provideEnvironment(r)
    def updateLabelGroup(request: UpdateLabelGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest,
        UpdateLabelGroupResponse
      ]("updateLabelGroup", api.updateLabelGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeRetrainingScheduler(
        request: DescribeRetrainingSchedulerRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerRequest,
      DescribeRetrainingSchedulerResponse
    ]("describeRetrainingScheduler", api.describeRetrainingScheduler)(
      request.buildAwsValue()
    ).map(
      zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.wrap
    ).provideEnvironment(r)
    def deleteInferenceScheduler(
        request: DeleteInferenceSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest,
      DeleteInferenceSchedulerResponse
    ]("deleteInferenceScheduler", api.deleteInferenceScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteResourcePolicy(
        request: DeleteResourcePolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listSensorStatistics(request: ListSensorStatisticsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest,
      ListSensorStatisticsResponse,
      SensorStatisticsSummary
    ](
      "listSensorStatistics",
      api.listSensorStatistics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.sensorStatisticsSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.SensorStatisticsSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listSensorStatisticsPaginated(request: ListSensorStatisticsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest,
      ListSensorStatisticsResponse
    ]("listSensorStatistics", api.listSensorStatistics)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(request: ListDatasetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest,
      ListDatasetsResponse,
      DatasetSummary
    ](
      "listDatasets",
      api.listDatasets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.DatasetSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetsPaginated(request: ListDatasetsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest,
      ListDatasetsResponse
    ]("listDatasets", api.listDatasets)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListDatasetsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateInferenceScheduler(
        request: UpdateInferenceSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest,
      UpdateInferenceSchedulerResponse
    ]("updateInferenceScheduler", api.updateInferenceScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def createLabelGroup(request: CreateLabelGroupRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest,
      CreateLabelGroupResponse
    ]("createLabelGroup", api.createLabelGroup)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateLabelGroupResponse.wrap)
      .provideEnvironment(r)
    def listRetrainingSchedulers(
        request: ListRetrainingSchedulersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest,
      ListRetrainingSchedulersResponse,
      RetrainingSchedulerSummary
    ](
      "listRetrainingSchedulers",
      api.listRetrainingSchedulers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.retrainingSchedulerSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRetrainingSchedulersPaginated(
        request: ListRetrainingSchedulersRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest,
      ListRetrainingSchedulersResponse
    ]("listRetrainingSchedulers", api.listRetrainingSchedulers)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.wrap)
      .provideEnvironment(r)
    def createLabel(request: CreateLabelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest,
      CreateLabelResponse
    ]("createLabel", api.createLabel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateLabelResponse.wrap)
      .provideEnvironment(r)
    def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest,
      DescribeResourcePolicyResponse
    ]("describeResourcePolicy", api.describeResourcePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def listModelVersions(request: ListModelVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest,
      ListModelVersionsResponse,
      ModelVersionSummary
    ](
      "listModelVersions",
      api.listModelVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelVersionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.ModelVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listModelVersionsPaginated(request: ListModelVersionsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest,
      ListModelVersionsResponse
    ]("listModelVersions", api.listModelVersions)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListModelVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateRetrainingScheduler(
        request: UpdateRetrainingSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest,
      UpdateRetrainingSchedulerResponse
    ]("updateRetrainingScheduler", api.updateRetrainingScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteLabelGroup(request: DeleteLabelGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest,
        DeleteLabelGroupResponse
      ]("deleteLabelGroup", api.deleteLabelGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateActiveModelVersion(request: UpdateActiveModelVersionRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest,
      UpdateActiveModelVersionResponse
    ]("updateActiveModelVersion", api.updateActiveModelVersion)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.wrap)
      .provideEnvironment(r)
    def startDataIngestionJob(request: StartDataIngestionJobRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest,
      StartDataIngestionJobResponse
    ]("startDataIngestionJob", api.startDataIngestionJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.wrap)
      .provideEnvironment(r)
    def listInferenceSchedulers(
        request: ListInferenceSchedulersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest,
      ListInferenceSchedulersResponse,
      InferenceSchedulerSummary
    ](
      "listInferenceSchedulers",
      api.listInferenceSchedulers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceSchedulerSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.InferenceSchedulerSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceSchedulersPaginated(
        request: ListInferenceSchedulersRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest,
      ListInferenceSchedulersResponse
    ]("listInferenceSchedulers", api.listInferenceSchedulers)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.wrap)
      .provideEnvironment(r)
    def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest,
      DescribeDataIngestionJobResponse
    ]("describeDataIngestionJob", api.describeDataIngestionJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.wrap)
      .provideEnvironment(r)
    def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest,
      ListDataIngestionJobsResponse,
      DataIngestionJobSummary
    ](
      "listDataIngestionJobs",
      api.listDataIngestionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataIngestionJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.DataIngestionJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDataIngestionJobsPaginated(
        request: ListDataIngestionJobsRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest,
      ListDataIngestionJobsResponse
    ]("listDataIngestionJobs", api.listDataIngestionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.wrap)
      .provideEnvironment(r)
    def describeModel(request: DescribeModelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest,
      DescribeModelResponse
    ]("describeModel", api.describeModel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeModelResponse.wrap)
      .provideEnvironment(r)
    def describeModelVersion(request: DescribeModelVersionRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeModelVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest,
      DescribeModelVersionResponse
    ]("describeModelVersion", api.describeModelVersion)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeModelVersionResponse.wrap)
      .provideEnvironment(r)
  }
  def listInferenceExecutions(request: ListInferenceExecutionsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceExecutions(request))
  def listInferenceExecutionsPaginated(
      request: ListInferenceExecutionsRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceExecutionsPaginated(request))
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listModels(request: ListModelsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModels(request))
  def listModelsPaginated(
      request: ListModelsRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listModelsPaginated(request))
  def importModelVersion(request: ImportModelVersionRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ImportModelVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importModelVersion(request))
  def startInferenceScheduler(request: StartInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startInferenceScheduler(request))
  def listInferenceEvents(request: ListInferenceEventsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceEvents(request))
  def listInferenceEventsPaginated(request: ListInferenceEventsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceEventsPaginated(request))
  def listLabels(request: ListLabelsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.LabelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLabels(request))
  def listLabelsPaginated(request: ListLabelsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLabelsPaginated(request))
  def createModel(request: CreateModelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def updateModel(
      request: UpdateModelRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateModel(request))
  def describeLabelGroup(request: DescribeLabelGroupRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLabelGroup(request))
  def startRetrainingScheduler(request: StartRetrainingSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StartRetrainingSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRetrainingScheduler(request))
  def stopRetrainingScheduler(request: StopRetrainingSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StopRetrainingSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopRetrainingScheduler(request))
  def listLabelGroups(request: ListLabelGroupsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLabelGroups(request))
  def listLabelGroupsPaginated(request: ListLabelGroupsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLabelGroupsPaginated(request))
  def putResourcePolicy(request: PutResourcePolicyRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def deleteRetrainingScheduler(
      request: DeleteRetrainingSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRetrainingScheduler(request))
  def stopInferenceScheduler(request: StopInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopInferenceScheduler(request))
  def deleteLabel(
      request: DeleteLabelRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLabel(request))
  def describeDataset(request: DescribeDatasetRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def deleteModel(
      request: DeleteModelRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModel(request))
  def createRetrainingScheduler(request: CreateRetrainingSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateRetrainingSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRetrainingScheduler(request))
  def createInferenceScheduler(request: CreateInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInferenceScheduler(request))
  def importDataset(request: ImportDatasetRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ImportDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importDataset(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeLabel(request: DescribeLabelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeLabelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLabel(request))
  def describeInferenceScheduler(
      request: DescribeInferenceSchedulerRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInferenceScheduler(request))
  def updateLabelGroup(
      request: UpdateLabelGroupRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateLabelGroup(request))
  def describeRetrainingScheduler(
      request: DescribeRetrainingSchedulerRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeRetrainingSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRetrainingScheduler(request))
  def deleteInferenceScheduler(
      request: DeleteInferenceSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteInferenceScheduler(request))
  def deleteResourcePolicy(
      request: DeleteResourcePolicyRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def listSensorStatistics(request: ListSensorStatisticsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSensorStatistics(request))
  def listSensorStatisticsPaginated(request: ListSensorStatisticsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSensorStatisticsPaginated(request))
  def listDatasets(request: ListDatasetsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(request: ListDatasetsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateInferenceScheduler(
      request: UpdateInferenceSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateInferenceScheduler(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createLabelGroup(request: CreateLabelGroupRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLabelGroup(request))
  def listRetrainingSchedulers(
      request: ListRetrainingSchedulersRequest
  ): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.RetrainingSchedulerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRetrainingSchedulers(request))
  def listRetrainingSchedulersPaginated(
      request: ListRetrainingSchedulersRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListRetrainingSchedulersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRetrainingSchedulersPaginated(request))
  def createLabel(request: CreateLabelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLabel(request))
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourcePolicy(request))
  def listModelVersions(request: ListModelVersionsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ModelVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelVersions(request))
  def listModelVersionsPaginated(request: ListModelVersionsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListModelVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelVersionsPaginated(request))
  def updateRetrainingScheduler(
      request: UpdateRetrainingSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRetrainingScheduler(request))
  def deleteLabelGroup(
      request: DeleteLabelGroupRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLabelGroup(request))
  def deleteDataset(
      request: DeleteDatasetRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataset(request))
  def updateActiveModelVersion(request: UpdateActiveModelVersionRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.UpdateActiveModelVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateActiveModelVersion(request))
  def startDataIngestionJob(request: StartDataIngestionJobRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDataIngestionJob(request))
  def listInferenceSchedulers(request: ListInferenceSchedulersRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceSchedulers(request))
  def listInferenceSchedulersPaginated(
      request: ListInferenceSchedulersRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceSchedulersPaginated(request))
  def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataIngestionJob(request))
  def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataIngestionJobs(request))
  def listDataIngestionJobsPaginated(
      request: ListDataIngestionJobsRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataIngestionJobsPaginated(request))
  def describeModel(request: DescribeModelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModel(request))
  def describeModelVersion(request: DescribeModelVersionRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeModelVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModelVersion(request))
}
