package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{FaultCode, LabelGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLabelGroupRequest(
    labelGroupName: LabelGroupName,
    faultCodes: Optional[Iterable[FaultCode]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest = {
    import UpdateLabelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .optionallyWith(
        faultCodes.map(value =>
          value.map { item =>
            FaultCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.faultCodes)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.UpdateLabelGroupRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UpdateLabelGroupRequest.wrap(buildAwsValue())
}
object UpdateLabelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.UpdateLabelGroupRequest =
      zio.aws.lookoutequipment.model
        .UpdateLabelGroupRequest(labelGroupName, faultCodes.map(value => value))
    def labelGroupName: LabelGroupName
    def faultCodes: Optional[List[FaultCode]]
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getFaultCodes: ZIO[Any, AwsError, List[FaultCode]] =
      AwsError.unwrapOptionField("faultCodes", faultCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest
  ) extends zio.aws.lookoutequipment.model.UpdateLabelGroupRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val faultCodes: Optional[List[FaultCode]] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.primitives.FaultCode(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest
  ): zio.aws.lookoutequipment.model.UpdateLabelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
