package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.AmazonResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceArn,
    tags: Iterable[zio.aws.lookoutequipment.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.TagResourceRequest.ReadOnly =
    zio.aws.lookoutequipment.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.TagResourceRequest =
      zio.aws.lookoutequipment.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceArn
    def tags: List[zio.aws.lookoutequipment.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest
  ) extends zio.aws.lookoutequipment.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceArn =
      zio.aws.lookoutequipment.model.primitives
        .AmazonResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.lookoutequipment.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.lookoutequipment.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest
  ): zio.aws.lookoutequipment.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
