package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  InferenceSchedulerArn,
  InferenceSchedulerName,
  ModelName,
  ModelArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopInferenceSchedulerResponse(
    modelArn: Optional[ModelArn] = Optional.Absent,
    modelName: Optional[ModelName] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse = {
    import StopInferenceSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse
      .wrap(buildAwsValue())
}
object StopInferenceSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse =
      zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse(
        modelArn.map(value => value),
        modelName.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value)
      )
    def modelArn: Optional[ModelArn]
    def modelName: Optional[ModelName]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly {
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse
  ): zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
