package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IdempotenceToken,
  IamRoleArn,
  DatasetIdentifier
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDataIngestionJobRequest(
    datasetName: DatasetIdentifier,
    ingestionInputConfiguration: zio.aws.lookoutequipment.model.IngestionInputConfiguration,
    roleArn: IamRoleArn,
    clientToken: IdempotenceToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest = {
    import StartDataIngestionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest
      .builder()
      .datasetName(DatasetIdentifier.unwrap(datasetName): java.lang.String)
      .ingestionInputConfiguration(ingestionInputConfiguration.buildAwsValue())
      .roleArn(IamRoleArn.unwrap(roleArn): java.lang.String)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StartDataIngestionJobRequest.ReadOnly =
    zio.aws.lookoutequipment.model.StartDataIngestionJobRequest
      .wrap(buildAwsValue())
}
object StartDataIngestionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StartDataIngestionJobRequest =
      zio.aws.lookoutequipment.model.StartDataIngestionJobRequest(
        datasetName,
        ingestionInputConfiguration.asEditable,
        roleArn,
        clientToken
      )
    def datasetName: DatasetIdentifier
    def ingestionInputConfiguration
        : zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    def roleArn: IamRoleArn
    def clientToken: IdempotenceToken
    def getDatasetName: ZIO[Any, Nothing, DatasetIdentifier] =
      ZIO.succeed(datasetName)
    def getIngestionInputConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = ZIO.succeed(ingestionInputConfiguration)
    def getRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(roleArn)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest
  ) extends zio.aws.lookoutequipment.model.StartDataIngestionJobRequest.ReadOnly {
    override val datasetName: DatasetIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .DatasetIdentifier(impl.datasetName())
    override val ingestionInputConfiguration
        : zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly =
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
        .wrap(impl.ingestionInputConfiguration())
    override val roleArn: IamRoleArn =
      zio.aws.lookoutequipment.model.primitives.IamRoleArn(impl.roleArn())
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest
  ): zio.aws.lookoutequipment.model.StartDataIngestionJobRequest.ReadOnly =
    new Wrapper(impl)
}
