package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  SensorName,
  ComponentName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SensorStatisticsSummary(
    componentName: Optional[ComponentName] = Optional.Absent,
    sensorName: Optional[SensorName] = Optional.Absent,
    dataExists: Optional[Boolean] = Optional.Absent,
    missingValues: Optional[zio.aws.lookoutequipment.model.CountPercent] =
      Optional.Absent,
    invalidValues: Optional[zio.aws.lookoutequipment.model.CountPercent] =
      Optional.Absent,
    invalidDateEntries: Optional[zio.aws.lookoutequipment.model.CountPercent] =
      Optional.Absent,
    duplicateTimestamps: Optional[zio.aws.lookoutequipment.model.CountPercent] =
      Optional.Absent,
    categoricalValues: Optional[
      zio.aws.lookoutequipment.model.CategoricalValues
    ] = Optional.Absent,
    multipleOperatingModes: Optional[
      zio.aws.lookoutequipment.model.MultipleOperatingModes
    ] = Optional.Absent,
    largeTimestampGaps: Optional[
      zio.aws.lookoutequipment.model.LargeTimestampGaps
    ] = Optional.Absent,
    monotonicValues: Optional[zio.aws.lookoutequipment.model.MonotonicValues] =
      Optional.Absent,
    dataStartTime: Optional[Timestamp] = Optional.Absent,
    dataEndTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary = {
    import SensorStatisticsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary
      .builder()
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .optionallyWith(
        sensorName.map(value => SensorName.unwrap(value): java.lang.String)
      )(_.sensorName)
      .optionallyWith(dataExists.map(value => value: java.lang.Boolean))(
        _.dataExists
      )
      .optionallyWith(missingValues.map(value => value.buildAwsValue()))(
        _.missingValues
      )
      .optionallyWith(invalidValues.map(value => value.buildAwsValue()))(
        _.invalidValues
      )
      .optionallyWith(invalidDateEntries.map(value => value.buildAwsValue()))(
        _.invalidDateEntries
      )
      .optionallyWith(duplicateTimestamps.map(value => value.buildAwsValue()))(
        _.duplicateTimestamps
      )
      .optionallyWith(categoricalValues.map(value => value.buildAwsValue()))(
        _.categoricalValues
      )
      .optionallyWith(
        multipleOperatingModes.map(value => value.buildAwsValue())
      )(_.multipleOperatingModes)
      .optionallyWith(largeTimestampGaps.map(value => value.buildAwsValue()))(
        _.largeTimestampGaps
      )
      .optionallyWith(monotonicValues.map(value => value.buildAwsValue()))(
        _.monotonicValues
      )
      .optionallyWith(
        dataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTime)
      .optionallyWith(
        dataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly =
    zio.aws.lookoutequipment.model.SensorStatisticsSummary.wrap(buildAwsValue())
}
object SensorStatisticsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.SensorStatisticsSummary =
      zio.aws.lookoutequipment.model.SensorStatisticsSummary(
        componentName.map(value => value),
        sensorName.map(value => value),
        dataExists.map(value => value),
        missingValues.map(value => value.asEditable),
        invalidValues.map(value => value.asEditable),
        invalidDateEntries.map(value => value.asEditable),
        duplicateTimestamps.map(value => value.asEditable),
        categoricalValues.map(value => value.asEditable),
        multipleOperatingModes.map(value => value.asEditable),
        largeTimestampGaps.map(value => value.asEditable),
        monotonicValues.map(value => value.asEditable),
        dataStartTime.map(value => value),
        dataEndTime.map(value => value)
      )
    def componentName: Optional[ComponentName]
    def sensorName: Optional[SensorName]
    def dataExists: Optional[Boolean]
    def missingValues
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly]
    def invalidValues
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly]
    def invalidDateEntries
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly]
    def duplicateTimestamps
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly]
    def categoricalValues
        : Optional[zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly]
    def multipleOperatingModes: Optional[
      zio.aws.lookoutequipment.model.MultipleOperatingModes.ReadOnly
    ]
    def largeTimestampGaps
        : Optional[zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly]
    def monotonicValues
        : Optional[zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly]
    def dataStartTime: Optional[Timestamp]
    def dataEndTime: Optional[Timestamp]
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getSensorName: ZIO[Any, AwsError, SensorName] =
      AwsError.unwrapOptionField("sensorName", sensorName)
    def getDataExists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataExists", dataExists)
    def getMissingValues: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.CountPercent.ReadOnly
    ] = AwsError.unwrapOptionField("missingValues", missingValues)
    def getInvalidValues: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.CountPercent.ReadOnly
    ] = AwsError.unwrapOptionField("invalidValues", invalidValues)
    def getInvalidDateEntries: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.CountPercent.ReadOnly
    ] = AwsError.unwrapOptionField("invalidDateEntries", invalidDateEntries)
    def getDuplicateTimestamps: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.CountPercent.ReadOnly
    ] = AwsError.unwrapOptionField("duplicateTimestamps", duplicateTimestamps)
    def getCategoricalValues: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly
    ] = AwsError.unwrapOptionField("categoricalValues", categoricalValues)
    def getMultipleOperatingModes: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.MultipleOperatingModes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multipleOperatingModes",
      multipleOperatingModes
    )
    def getLargeTimestampGaps: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly
    ] = AwsError.unwrapOptionField("largeTimestampGaps", largeTimestampGaps)
    def getMonotonicValues: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly
    ] = AwsError.unwrapOptionField("monotonicValues", monotonicValues)
    def getDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTime", dataStartTime)
    def getDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTime", dataEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary
  ) extends zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly {
    override val componentName: Optional[ComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ComponentName(value)
      )
    override val sensorName: Optional[SensorName] = zio.aws.core.internal
      .optionalFromNullable(impl.sensorName())
      .map(value => zio.aws.lookoutequipment.model.primitives.SensorName(value))
    override val dataExists: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataExists())
      .map(value => value: Boolean)
    override val missingValues
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missingValues())
        .map(value => zio.aws.lookoutequipment.model.CountPercent.wrap(value))
    override val invalidValues
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidValues())
        .map(value => zio.aws.lookoutequipment.model.CountPercent.wrap(value))
    override val invalidDateEntries
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidDateEntries())
        .map(value => zio.aws.lookoutequipment.model.CountPercent.wrap(value))
    override val duplicateTimestamps
        : Optional[zio.aws.lookoutequipment.model.CountPercent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.duplicateTimestamps())
        .map(value => zio.aws.lookoutequipment.model.CountPercent.wrap(value))
    override val categoricalValues
        : Optional[zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categoricalValues())
        .map(value =>
          zio.aws.lookoutequipment.model.CategoricalValues.wrap(value)
        )
    override val multipleOperatingModes: Optional[
      zio.aws.lookoutequipment.model.MultipleOperatingModes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multipleOperatingModes())
      .map(value =>
        zio.aws.lookoutequipment.model.MultipleOperatingModes.wrap(value)
      )
    override val largeTimestampGaps
        : Optional[zio.aws.lookoutequipment.model.LargeTimestampGaps.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.largeTimestampGaps())
        .map(value =>
          zio.aws.lookoutequipment.model.LargeTimestampGaps.wrap(value)
        )
    override val monotonicValues
        : Optional[zio.aws.lookoutequipment.model.MonotonicValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monotonicValues())
        .map(value =>
          zio.aws.lookoutequipment.model.MonotonicValues.wrap(value)
        )
    override val dataStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary
  ): zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly =
    new Wrapper(impl)
}
