package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait Monotonicity {
  def unwrap
      : software.amazon.awssdk.services.lookoutequipment.model.Monotonicity
}
object Monotonicity {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.Monotonicity
  ): zio.aws.lookoutequipment.model.Monotonicity = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.DECREASING =>
      val r = DECREASING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.INCREASING =>
      val r = INCREASING
      r
    case software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.STATIC =>
      val r = STATIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.Monotonicity {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.Monotonicity =
      software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.UNKNOWN_TO_SDK_VERSION
  }
  case object DECREASING extends zio.aws.lookoutequipment.model.Monotonicity {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.Monotonicity =
      software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.DECREASING
  }
  case object INCREASING extends zio.aws.lookoutequipment.model.Monotonicity {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.Monotonicity =
      software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.INCREASING
  }
  case object STATIC extends zio.aws.lookoutequipment.model.Monotonicity {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.Monotonicity =
      software.amazon.awssdk.services.lookoutequipment.model.Monotonicity.STATIC
  }
}
