package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MissingSensorData(
    affectedSensorCount: Integer,
    totalNumberOfMissingValues: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData = {
    import MissingSensorData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData
      .builder()
      .affectedSensorCount(affectedSensorCount: java.lang.Integer)
      .totalNumberOfMissingValues(totalNumberOfMissingValues: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly =
    zio.aws.lookoutequipment.model.MissingSensorData.wrap(buildAwsValue())
}
object MissingSensorData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.MissingSensorData =
      zio.aws.lookoutequipment.model
        .MissingSensorData(affectedSensorCount, totalNumberOfMissingValues)
    def affectedSensorCount: Integer
    def totalNumberOfMissingValues: Integer
    def getAffectedSensorCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(affectedSensorCount)
    def getTotalNumberOfMissingValues: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(totalNumberOfMissingValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData
  ) extends zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly {
    override val affectedSensorCount: Integer =
      impl.affectedSensorCount(): Integer
    override val totalNumberOfMissingValues: Integer =
      impl.totalNumberOfMissingValues(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.MissingSensorData
  ): zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly = new Wrapper(
    impl
  )
}
