package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSensorStatisticsResponse(
    sensorStatisticsSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.SensorStatisticsSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse = {
    import ListSensorStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse
      .builder()
      .optionallyWith(
        sensorStatisticsSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sensorStatisticsSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListSensorStatisticsResponse
      .wrap(buildAwsValue())
}
object ListSensorStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListSensorStatisticsResponse =
      zio.aws.lookoutequipment.model.ListSensorStatisticsResponse(
        sensorStatisticsSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sensorStatisticsSummaries: Optional[
      List[zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSensorStatisticsSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sensorStatisticsSummaries",
      sensorStatisticsSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse
  ) extends zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly {
    override val sensorStatisticsSummaries: Optional[
      List[zio.aws.lookoutequipment.model.SensorStatisticsSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensorStatisticsSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.SensorStatisticsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse
  ): zio.aws.lookoutequipment.model.ListSensorStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
