package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  NextToken,
  MaxResults,
  IngestionJobId,
  DatasetName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSensorStatisticsRequest(
    datasetName: DatasetName,
    ingestionJobId: Optional[IngestionJobId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest = {
    import ListSensorStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        ingestionJobId.map(value =>
          IngestionJobId.unwrap(value): java.lang.String
        )
      )(_.ingestionJobId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListSensorStatisticsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListSensorStatisticsRequest
      .wrap(buildAwsValue())
}
object ListSensorStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListSensorStatisticsRequest =
      zio.aws.lookoutequipment.model.ListSensorStatisticsRequest(
        datasetName,
        ingestionJobId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def datasetName: DatasetName
    def ingestionJobId: Optional[IngestionJobId]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getIngestionJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("ingestionJobId", ingestionJobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest
  ) extends zio.aws.lookoutequipment.model.ListSensorStatisticsRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.lookoutequipment.model.primitives.DatasetName(impl.datasetName())
    override val ingestionJobId: Optional[IngestionJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestionJobId())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest
  ): zio.aws.lookoutequipment.model.ListSensorStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
