package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    modelSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.ModelSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse = {
    import ListModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListModelsResponse.wrap(buildAwsValue())
}
object ListModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListModelsResponse =
      zio.aws.lookoutequipment.model.ListModelsResponse(
        nextToken.map(value => value),
        modelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def modelSummaries
        : Optional[List[zio.aws.lookoutequipment.model.ModelSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("modelSummaries", modelSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ) extends zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val modelSummaries
        : Optional[List[zio.aws.lookoutequipment.model.ModelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.ModelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ): zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
