package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  NextToken,
  Timestamp,
  FaultCode,
  MaxResults,
  Equipment,
  LabelGroupName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLabelsRequest(
    labelGroupName: LabelGroupName,
    intervalStartTime: Optional[Timestamp] = Optional.Absent,
    intervalEndTime: Optional[Timestamp] = Optional.Absent,
    faultCode: Optional[FaultCode] = Optional.Absent,
    equipment: Optional[Equipment] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest = {
    import ListLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .optionallyWith(
        intervalStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.intervalStartTime)
      .optionallyWith(
        intervalEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.intervalEndTime)
      .optionallyWith(
        faultCode.map(value => FaultCode.unwrap(value): java.lang.String)
      )(_.faultCode)
      .optionallyWith(
        equipment.map(value => Equipment.unwrap(value): java.lang.String)
      )(_.equipment)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListLabelsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListLabelsRequest.wrap(buildAwsValue())
}
object ListLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListLabelsRequest =
      zio.aws.lookoutequipment.model.ListLabelsRequest(
        labelGroupName,
        intervalStartTime.map(value => value),
        intervalEndTime.map(value => value),
        faultCode.map(value => value),
        equipment.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def labelGroupName: LabelGroupName
    def intervalStartTime: Optional[Timestamp]
    def intervalEndTime: Optional[Timestamp]
    def faultCode: Optional[FaultCode]
    def equipment: Optional[Equipment]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getIntervalStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("intervalStartTime", intervalStartTime)
    def getIntervalEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("intervalEndTime", intervalEndTime)
    def getFaultCode: ZIO[Any, AwsError, FaultCode] =
      AwsError.unwrapOptionField("faultCode", faultCode)
    def getEquipment: ZIO[Any, AwsError, Equipment] =
      AwsError.unwrapOptionField("equipment", equipment)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest
  ) extends zio.aws.lookoutequipment.model.ListLabelsRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val intervalStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.intervalStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val intervalEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.intervalEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val faultCode: Optional[FaultCode] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCode())
      .map(value => zio.aws.lookoutequipment.model.primitives.FaultCode(value))
    override val equipment: Optional[Equipment] = zio.aws.core.internal
      .optionalFromNullable(impl.equipment())
      .map(value => zio.aws.lookoutequipment.model.primitives.Equipment(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest
  ): zio.aws.lookoutequipment.model.ListLabelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
