package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLabelGroupsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    labelGroupSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.LabelGroupSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse = {
    import ListLabelGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        labelGroupSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labelGroupSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListLabelGroupsResponse.wrap(buildAwsValue())
}
object ListLabelGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListLabelGroupsResponse =
      zio.aws.lookoutequipment.model.ListLabelGroupsResponse(
        nextToken.map(value => value),
        labelGroupSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def labelGroupSummaries: Optional[
      List[zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLabelGroupSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("labelGroupSummaries", labelGroupSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse
  ) extends zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val labelGroupSummaries: Optional[
      List[zio.aws.lookoutequipment.model.LabelGroupSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelGroupSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.LabelGroupSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse
  ): zio.aws.lookoutequipment.model.ListLabelGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
