package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInferenceSchedulersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    inferenceSchedulerSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.InferenceSchedulerSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse = {
    import ListInferenceSchedulersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        inferenceSchedulerSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceSchedulerSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse
      .wrap(buildAwsValue())
}
object ListInferenceSchedulersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse =
      zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse(
        nextToken.map(value => value),
        inferenceSchedulerSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def inferenceSchedulerSummaries: Optional[
      List[zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInferenceSchedulerSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceSchedulerSummaries",
      inferenceSchedulerSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ) extends zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val inferenceSchedulerSummaries: Optional[
      List[zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSchedulerSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.InferenceSchedulerSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ): zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly =
    new Wrapper(impl)
}
