package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  ModelName,
  InferenceSchedulerIdentifier,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceSchedulersRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    inferenceSchedulerNameBeginsWith: Optional[InferenceSchedulerIdentifier] =
      Optional.Absent,
    modelName: Optional[ModelName] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest = {
    import ListInferenceSchedulersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        inferenceSchedulerNameBeginsWith.map(value =>
          InferenceSchedulerIdentifier.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerNameBeginsWith)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest
      .wrap(buildAwsValue())
}
object ListInferenceSchedulersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest =
      zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        inferenceSchedulerNameBeginsWith.map(value => value),
        modelName.map(value => value),
        status.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def inferenceSchedulerNameBeginsWith: Optional[InferenceSchedulerIdentifier]
    def modelName: Optional[ModelName]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getInferenceSchedulerNameBeginsWith
        : ZIO[Any, AwsError, InferenceSchedulerIdentifier] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerNameBeginsWith",
        inferenceSchedulerNameBeginsWith
      )
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ) extends zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val inferenceSchedulerNameBeginsWith
        : Optional[InferenceSchedulerIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSchedulerNameBeginsWith())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives
          .InferenceSchedulerIdentifier(value)
      )
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ): zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly =
    new Wrapper(impl)
}
