package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  InferenceSchedulerIdentifier,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceExecutionsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    inferenceSchedulerName: InferenceSchedulerIdentifier,
    dataStartTimeAfter: Optional[Timestamp] = Optional.Absent,
    dataEndTimeBefore: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest = {
    import ListInferenceExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .optionallyWith(
        dataStartTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTimeAfter)
      .optionallyWith(
        dataEndTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTimeBefore)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest
      .wrap(buildAwsValue())
}
object ListInferenceExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest =
      zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        inferenceSchedulerName,
        dataStartTimeAfter.map(value => value),
        dataEndTimeBefore.map(value => value),
        status.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def dataStartTimeAfter: Optional[Timestamp]
    def dataEndTimeBefore: Optional[Timestamp]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
    def getDataStartTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTimeAfter", dataStartTimeAfter)
    def getDataEndTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTimeBefore", dataEndTimeBefore)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ) extends zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
    override val dataStartTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStartTimeAfter())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEndTimeBefore())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceExecutionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ): zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
