package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInferenceEventsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    inferenceEventSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.InferenceEventSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse = {
    import ListInferenceEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        inferenceEventSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceEventSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceEventsResponse
      .wrap(buildAwsValue())
}
object ListInferenceEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListInferenceEventsResponse =
      zio.aws.lookoutequipment.model.ListInferenceEventsResponse(
        nextToken.map(value => value),
        inferenceEventSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def inferenceEventSummaries: Optional[
      List[zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInferenceEventSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceEventSummaries",
      inferenceEventSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse
  ) extends zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val inferenceEventSummaries: Optional[
      List[zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceEventSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.InferenceEventSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse
  ): zio.aws.lookoutequipment.model.ListInferenceEventsResponse.ReadOnly =
    new Wrapper(impl)
}
