package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  InferenceSchedulerIdentifier,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceEventsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    inferenceSchedulerName: InferenceSchedulerIdentifier,
    intervalStartTime: Timestamp,
    intervalEndTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest = {
    import ListInferenceEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .intervalStartTime(Timestamp.unwrap(intervalStartTime): Instant)
      .intervalEndTime(Timestamp.unwrap(intervalEndTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceEventsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceEventsRequest
      .wrap(buildAwsValue())
}
object ListInferenceEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListInferenceEventsRequest =
      zio.aws.lookoutequipment.model.ListInferenceEventsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        inferenceSchedulerName,
        intervalStartTime,
        intervalEndTime
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def intervalStartTime: Timestamp
    def intervalEndTime: Timestamp
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
    def getIntervalStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(intervalStartTime)
    def getIntervalEndTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(intervalEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest
  ) extends zio.aws.lookoutequipment.model.ListInferenceEventsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
    override val intervalStartTime: Timestamp =
      zio.aws.lookoutequipment.model.primitives
        .Timestamp(impl.intervalStartTime())
    override val intervalEndTime: Timestamp =
      zio.aws.lookoutequipment.model.primitives
        .Timestamp(impl.intervalEndTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest
  ): zio.aws.lookoutequipment.model.ListInferenceEventsRequest.ReadOnly =
    new Wrapper(impl)
}
