package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatasetsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    datasetSummaries: Optional[
      Iterable[zio.aws.lookoutequipment.model.DatasetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        datasetSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListDatasetsResponse =
      zio.aws.lookoutequipment.model.ListDatasetsResponse(
        nextToken.map(value => value),
        datasetSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def datasetSummaries
        : Optional[List[zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDatasetSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetSummaries", datasetSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse
  ) extends zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val datasetSummaries: Optional[
      List[zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.DatasetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse
  ): zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
