package zio.aws.lookoutequipment.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  DatasetName,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    datasetNameBeginsWith: Optional[DatasetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest = {
    import ListDatasetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        datasetNameBeginsWith.map(value =>
          DatasetName.unwrap(value): java.lang.String
        )
      )(_.datasetNameBeginsWith)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListDatasetsRequest.wrap(buildAwsValue())
}
object ListDatasetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListDatasetsRequest =
      zio.aws.lookoutequipment.model.ListDatasetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        datasetNameBeginsWith.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def datasetNameBeginsWith: Optional[DatasetName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDatasetNameBeginsWith: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetNameBeginsWith", datasetNameBeginsWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ) extends zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val datasetNameBeginsWith: Optional[DatasetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetNameBeginsWith())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.DatasetName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ): zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
