package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.LabelGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelsInputConfiguration(
    s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsS3InputConfiguration
    ] = Optional.Absent,
    labelGroupName: Optional[LabelGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration = {
    import LabelsInputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration
      .builder()
      .optionallyWith(s3InputConfiguration.map(value => value.buildAwsValue()))(
        _.s3InputConfiguration
      )
      .optionallyWith(
        labelGroupName.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.LabelsInputConfiguration
      .wrap(buildAwsValue())
}
object LabelsInputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.LabelsInputConfiguration =
      zio.aws.lookoutequipment.model.LabelsInputConfiguration(
        s3InputConfiguration.map(value => value.asEditable),
        labelGroupName.map(value => value)
      )
    def s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsS3InputConfiguration.ReadOnly
    ]
    def labelGroupName: Optional[LabelGroupName]
    def getS3InputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsS3InputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3InputConfiguration", s3InputConfiguration)
    def getLabelGroupName: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField("labelGroupName", labelGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration
  ) extends zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly {
    override val s3InputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsS3InputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3InputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsS3InputConfiguration.wrap(value)
      )
    override val labelGroupName: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration
  ): zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly =
    new Wrapper(impl)
}
