package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait LabelRating {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.LabelRating
}
object LabelRating {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.LabelRating
  ): zio.aws.lookoutequipment.model.LabelRating = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.LabelRating.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.LabelRating.ANOMALY =>
      val r = ANOMALY
      r
    case software.amazon.awssdk.services.lookoutequipment.model.LabelRating.NO_ANOMALY =>
      val r = NO_ANOMALY
      r
    case software.amazon.awssdk.services.lookoutequipment.model.LabelRating.NEUTRAL =>
      val r = NEUTRAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.LabelRating {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.LabelRating =
      software.amazon.awssdk.services.lookoutequipment.model.LabelRating.UNKNOWN_TO_SDK_VERSION
  }
  case object ANOMALY extends zio.aws.lookoutequipment.model.LabelRating {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.LabelRating =
      software.amazon.awssdk.services.lookoutequipment.model.LabelRating.ANOMALY
  }
  case object NO_ANOMALY extends zio.aws.lookoutequipment.model.LabelRating {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.LabelRating =
      software.amazon.awssdk.services.lookoutequipment.model.LabelRating.NO_ANOMALY
  }
  case object NEUTRAL extends zio.aws.lookoutequipment.model.LabelRating {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.LabelRating =
      software.amazon.awssdk.services.lookoutequipment.model.LabelRating.NEUTRAL
  }
}
