package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InvalidSensorData(
    affectedSensorCount: Integer,
    totalNumberOfInvalidValues: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData = {
    import InvalidSensorData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData
      .builder()
      .affectedSensorCount(affectedSensorCount: java.lang.Integer)
      .totalNumberOfInvalidValues(totalNumberOfInvalidValues: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly =
    zio.aws.lookoutequipment.model.InvalidSensorData.wrap(buildAwsValue())
}
object InvalidSensorData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InvalidSensorData =
      zio.aws.lookoutequipment.model
        .InvalidSensorData(affectedSensorCount, totalNumberOfInvalidValues)
    def affectedSensorCount: Integer
    def totalNumberOfInvalidValues: Integer
    def getAffectedSensorCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(affectedSensorCount)
    def getTotalNumberOfInvalidValues: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(totalNumberOfInvalidValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData
  ) extends zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly {
    override val affectedSensorCount: Integer =
      impl.affectedSensorCount(): Integer
    override val totalNumberOfInvalidValues: Integer =
      impl.totalNumberOfInvalidValues(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InvalidSensorData
  ): zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly = new Wrapper(
    impl
  )
}
