package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IngestionInputConfiguration(
    s3InputConfiguration: zio.aws.lookoutequipment.model.IngestionS3InputConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration = {
    import IngestionInputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration
      .builder()
      .s3InputConfiguration(s3InputConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.IngestionInputConfiguration
      .wrap(buildAwsValue())
}
object IngestionInputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.IngestionInputConfiguration =
      zio.aws.lookoutequipment.model
        .IngestionInputConfiguration(s3InputConfiguration.asEditable)
    def s3InputConfiguration
        : zio.aws.lookoutequipment.model.IngestionS3InputConfiguration.ReadOnly
    def getS3InputConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.IngestionS3InputConfiguration.ReadOnly
    ] = ZIO.succeed(s3InputConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration
  ) extends zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly {
    override val s3InputConfiguration
        : zio.aws.lookoutequipment.model.IngestionS3InputConfiguration.ReadOnly =
      zio.aws.lookoutequipment.model.IngestionS3InputConfiguration
        .wrap(impl.s3InputConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration
  ): zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly =
    new Wrapper(impl)
}
