package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IngestedFilesSummary(
    totalNumberOfFiles: Integer,
    ingestedNumberOfFiles: Integer,
    discardedFiles: Optional[
      Iterable[zio.aws.lookoutequipment.model.S3Object]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary = {
    import IngestedFilesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary
      .builder()
      .totalNumberOfFiles(totalNumberOfFiles: java.lang.Integer)
      .ingestedNumberOfFiles(ingestedNumberOfFiles: java.lang.Integer)
      .optionallyWith(
        discardedFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.discardedFiles)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly =
    zio.aws.lookoutequipment.model.IngestedFilesSummary.wrap(buildAwsValue())
}
object IngestedFilesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.IngestedFilesSummary =
      zio.aws.lookoutequipment.model.IngestedFilesSummary(
        totalNumberOfFiles,
        ingestedNumberOfFiles,
        discardedFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalNumberOfFiles: Integer
    def ingestedNumberOfFiles: Integer
    def discardedFiles
        : Optional[List[zio.aws.lookoutequipment.model.S3Object.ReadOnly]]
    def getTotalNumberOfFiles: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(totalNumberOfFiles)
    def getIngestedNumberOfFiles: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(ingestedNumberOfFiles)
    def getDiscardedFiles: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.S3Object.ReadOnly
    ]] = AwsError.unwrapOptionField("discardedFiles", discardedFiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary
  ) extends zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly {
    override val totalNumberOfFiles: Integer =
      impl.totalNumberOfFiles(): Integer
    override val ingestedNumberOfFiles: Integer =
      impl.ingestedNumberOfFiles(): Integer
    override val discardedFiles
        : Optional[List[zio.aws.lookoutequipment.model.S3Object.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discardedFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.S3Object.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary
  ): zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly = new Wrapper(
    impl
  )
}
